/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARContourPickup {
    protected static final int[] _getContour_xdir;
    protected static final int[] _getContour_ydir;

    static {
        int[] nArray = new int[15];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[13] = -1;
        nArray[14] = -1;
        _getContour_xdir = nArray;
        int[] nArray2 = new int[15];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[7] = -1;
        nArray2[8] = -1;
        nArray2[9] = -1;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        _getContour_ydir = nArray2;
    }

    public boolean getContour(NyARBinRaster i_raster, int i_entry_x, int i_entry_y, NyARIntCoordinates o_coord) throws NyARException {
        assert (i_raster.isEqualBufferType(262146));
        NyARIntSize s = i_raster.getSize();
        return this.impl_getContour(i_raster, 0, 0, s.w - 1, s.h - 1, 0, i_entry_x, i_entry_y, o_coord);
    }

    public boolean getContour(NyARBinRaster i_raster, NyARIntRect i_area, int i_entry_x, int i_entry_y, NyARIntCoordinates o_coord) throws NyARException {
        assert (i_raster.isEqualBufferType(262146));
        return this.impl_getContour(i_raster, i_area.x, i_area.y, i_area.x + i_area.w - 1, i_area.h + i_area.y - 1, 0, i_entry_x, i_entry_y, o_coord);
    }

    public boolean getContour(NyARGrayscaleRaster i_raster, int i_th, int i_entry_x, int i_entry_y, NyARIntCoordinates o_coord) throws NyARException {
        assert (i_raster.isEqualBufferType(262145));
        NyARIntSize s = i_raster.getSize();
        return this.impl_getContour(i_raster, 0, 0, s.w - 1, s.h - 1, i_th, i_entry_x, i_entry_y, o_coord);
    }

    public boolean getContour(NyARGrayscaleRaster i_raster, NyARIntRect i_area, int i_th, int i_entry_x, int i_entry_y, NyARIntCoordinates o_coord) throws NyARException {
        assert (i_raster.isEqualBufferType(262145));
        return this.impl_getContour(i_raster, i_area.x, i_area.y, i_area.x + i_area.w - 1, i_area.h + i_area.y - 1, i_th, i_entry_x, i_entry_y, o_coord);
    }

    private boolean impl_getContour(INyARRaster i_raster, int i_l, int i_t, int i_r, int i_b, int i_th, int i_entry_x, int i_entry_y, NyARIntCoordinates o_coord) throws NyARException {
        int coord_num;
        block10: {
            assert (i_t <= i_entry_x);
            NyARIntPoint2d[] coord = o_coord.items;
            int[] xdir = _getContour_xdir;
            int[] ydir = _getContour_ydir;
            int[] buf = (int[])i_raster.getBuffer();
            int width = i_raster.getWidth();
            int max_coord = o_coord.items.length;
            coord_num = 1;
            coord[0].x = i_entry_x;
            coord[0].y = i_entry_y;
            int dir = 5;
            int c = i_entry_x;
            int r = i_entry_y;
            do {
                int y;
                int x;
                int i;
                dir = (dir + 5) % 8;
                if (c > i_l && c < i_r && r > i_t && r < i_b) {
                    if (buf[(r + ydir[dir]) * width + (c + xdir[dir])] > i_th && buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th) {
                        throw new NyARException();
                    }
                } else {
                    i = 0;
                    while (i < 8) {
                        x = c + xdir[dir];
                        y = r + ydir[dir];
                        if (x >= i_l && x <= i_r && y >= i_t && y <= i_b && buf[y * width + x] <= i_th) break;
                        ++dir;
                        ++i;
                    }
                    if (i == 8) {
                        throw new NyARException();
                    }
                }
                coord[coord_num].x = c += xdir[dir];
                coord[coord_num].y = r += ydir[dir];
                if (c != i_entry_x || r != i_entry_y) continue;
                if (++coord_num == max_coord) {
                    return false;
                }
                dir = (dir + 5) % 8;
                i = 0;
                while (i < 8) {
                    x = c + xdir[dir];
                    y = r + ydir[dir];
                    if (x >= i_l && x <= i_r && y >= i_t && y <= i_b && buf[y * width + x] <= i_th) break;
                    ++dir;
                    ++i;
                }
                if (i == 8) {
                    throw new NyARException();
                }
                if (coord[1].x == (c += xdir[dir]) && coord[1].y == (r += ydir[dir])) break block10;
                coord[coord_num].x = c;
                coord[coord_num].y = r;
            } while (++coord_num != max_coord);
            return false;
        }
        o_coord.length = coord_num;
        return true;
    }
}

