/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.utils;

import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;

public class NyARDistMap {
    protected DistItem[] _map;
    protected int _min_dist = Integer.MAX_VALUE;
    protected int _min_dist_index = 0;
    protected int _size_row;
    protected int _size_col;

    public NyARDistMap(int i_max_col, int i_max_row) {
        this._size_col = i_max_col;
        this._size_row = i_max_row;
        this._map = new DistItem[i_max_col * i_max_row];
        int i = 0;
        while (i < i_max_col * i_max_row) {
            this._map[i] = new DistItem();
            ++i;
        }
    }

    public void setMapSize(int i_col, int i_row) {
        this._size_row = i_row;
        this._size_col = i_col;
    }

    public void setDist(int i_col, int i_row, int i_dist) {
        this._min_dist_index = this._size_col * i_row + i_col;
        DistItem item = this._map[this._min_dist_index];
        item.col = i_col;
        item.row = i_row;
        item.dist = i_dist;
        if (i_dist < this._min_dist) {
            this._min_dist = i_dist;
        }
    }

    public void setPointDists(NyARIntPoint2d[] i_vertex_r, int i_row_len, NyARIntPoint2d[] i_vertex_c, int i_col_len) {
        DistItem[] map = this._map;
        int min_index = 0;
        int min_dist = Integer.MAX_VALUE;
        int idx = 0;
        int r = 0;
        while (r < i_row_len) {
            int c = 0;
            while (c < i_col_len) {
                int d;
                map[idx].col = c;
                map[idx].row = r;
                map[idx].dist = d = i_vertex_r[r].sqDist(i_vertex_c[c]);
                if (min_dist > d) {
                    min_index = idx;
                    min_dist = d;
                }
                ++idx;
                ++c;
            }
            ++r;
        }
        this._min_dist = min_dist;
        this._min_dist_index = min_index;
        this._size_col = i_col_len;
        this._size_row = i_row_len;
    }

    public void getMinimumPair(int[] o_rowindex) {
        DistItem[] map = this._map;
        int map_length = this._size_col * this._size_row;
        int col_len = this._size_col;
        DistItem temp_map = map[0];
        map[0] = map[this._min_dist_index];
        map[this._min_dist_index] = temp_map;
        int i = 0;
        while (i < o_rowindex.length) {
            o_rowindex[i] = -1;
            ++i;
        }
        if (map_length == 0) {
            return;
        }
        o_rowindex[map[0].col] = map[0].row;
        i = 1;
        while (i < col_len) {
            int min_index = 0;
            int reject_c = map[i - 1].col;
            int reject_r = map[i - 1].row;
            int min_dist = Integer.MAX_VALUE;
            if (1 >= map_length - col_len) break;
            int i2 = i;
            while (i2 < map_length) {
                if (map[i2].col == reject_c || map[i2].row == reject_r) {
                    temp_map = map[i2];
                    map[i2] = map[map_length - 1];
                    map[map_length - 1] = temp_map;
                    --map_length;
                    continue;
                }
                int d = map[i2].dist;
                if (min_dist > d) {
                    min_index = i2;
                    min_dist = d;
                }
                ++i2;
            }
            temp_map = map[i];
            map[i] = map[min_index];
            map[min_index] = temp_map;
            o_rowindex[map[i].col] = map[i].row;
            ++i;
        }
    }

    protected class DistItem {
        public int row;
        public int col;
        public int dist;

        protected DistItem() {
        }
    }
}

