/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.rpf.sampler.lrlabel.LowResolutionLabelingSamplerOut;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.INyARVectorReader;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARContourTargetStatus;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARRectTargetStatusPool;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARTargetStatus;
import jp.nyatla.nyartoolkit.rpf.utils.VecLinearCoordinates;

public class NyARRectTargetStatus
extends NyARTargetStatus {
    private NyARRectTargetStatusPool _ref_my_pool;
    public NyARDoublePoint2d[] vertex = NyARDoublePoint2d.createArray(4);
    public int estimate_sum_sq_vertex_velocity_ave;
    public NyARIntRect estimate_rect = new NyARIntRect();
    public NyARDoublePoint2d[] estimate_vertex = NyARDoublePoint2d.createArray(4);
    public int detect_type;
    public static final int DT_SQINIT = 0;
    public static final int DT_SQDAILY = 1;
    public static final int DT_LIDAILY = 2;
    public static final int DT_FAILED = -1;
    private static final int[] _gcd_table4 = new int[]{-1, 1, 2, 1};

    public NyARRectTargetStatus(NyARRectTargetStatusPool i_pool) {
        super(i_pool._op_interface);
        this._ref_my_pool = i_pool;
        this.detect_type = 0;
    }

    private final void setEstimateParam(NyARRectTargetStatus i_prev_param) {
        NyARDoublePoint2d[] vc_ptr = this.vertex;
        NyARDoublePoint2d[] ve_ptr = this.estimate_vertex;
        int sum_of_vertex_sq_dist = 0;
        if (i_prev_param != null) {
            NyARDoublePoint2d[] vp = i_prev_param.vertex;
            int i = 3;
            while (i >= 0) {
                int x = (int)(vc_ptr[i].x - vp[i].x);
                int y = (int)(vc_ptr[i].y - vp[i].y);
                ve_ptr[i].x = (int)vc_ptr[i].x + x;
                ve_ptr[i].y = (int)vc_ptr[i].y + y;
                sum_of_vertex_sq_dist += x * x + y * y;
                --i;
            }
        } else {
            int i = 3;
            while (i >= 0) {
                ve_ptr[i].x = (int)vc_ptr[i].x;
                ve_ptr[i].y = (int)vc_ptr[i].y;
                --i;
            }
        }
        this.estimate_sum_sq_vertex_velocity_ave = sum_of_vertex_sq_dist / 4;
        this.estimate_rect.setAreaRect(ve_ptr, 4);
    }

    public boolean setValueWithInitialCheck(NyARContourTargetStatus i_contour_status, NyARIntRect i_sample_area) throws NyARException {
        i_contour_status.vecpos.limitQuadrantTo12();
        this._ref_my_pool._vecpos_op.margeResembleCoords(i_contour_status.vecpos);
        if (i_contour_status.vecpos.length < 4) {
            return false;
        }
        i_contour_status.vecpos.getKeyCoord(this._ref_my_pool._indexbuf);
        NyARDoublePoint2d[] this_vx = this.vertex;
        if (!this._ref_my_pool._line_detect.line2SquareVertex(this._ref_my_pool._indexbuf, this_vx)) {
            return false;
        }
        this.setEstimateParam(null);
        if (!this.checkInitialRectCondition(i_sample_area)) {
            return false;
        }
        this.detect_type = 0;
        return true;
    }

    private boolean setValueWithDeilyCheck(INyARVectorReader i_vec_reader, LowResolutionLabelingSamplerOut.Item i_source, NyARRectTargetStatus i_prev_status) throws NyARException {
        VecLinearCoordinates vecpos = this._ref_my_pool._vecpos;
        if (!i_vec_reader.traceConture(i_source.lebeling_th, i_source.entry_pos, vecpos)) {
            return false;
        }
        vecpos.limitQuadrantTo12();
        this._ref_my_pool._vecpos_op.margeResembleCoords(vecpos);
        if (vecpos.length < 4) {
            return false;
        }
        vecpos.getKeyCoord(this._ref_my_pool._indexbuf);
        NyARDoublePoint2d[] this_vx = this.vertex;
        if (!this._ref_my_pool._line_detect.line2SquareVertex(this._ref_my_pool._indexbuf, this_vx)) {
            return false;
        }
        NyARRectTargetStatus.rotateVertexL(this.vertex, NyARRectTargetStatus.checkVertexShiftValue(i_prev_status.vertex, this.vertex));
        if (!this.checkDeilyRectCondition(i_prev_status)) {
            return false;
        }
        this.setEstimateParam(i_prev_status);
        return true;
    }

    private boolean setValueByLineLog(INyARVectorReader i_vec_reader, NyARRectTargetStatus i_prev_status) throws NyARException {
        NyARLinear[] sh_l;
        int v_ave_limit = i_prev_status.estimate_sum_sq_vertex_velocity_ave;
        int d = i_prev_status.estimate_rect.getDiagonalSqDist() / 1600;
        if (v_ave_limit > d) {
            return false;
        }
        if ((d = (int)Math.sqrt(d)) < 2) {
            d = 2;
        }
        if (d > 5) {
            d = 5;
        }
        if (!this.traceSquareLine(i_vec_reader, d, i_prev_status, sh_l = this._ref_my_pool._line)) {
            return false;
        }
        int i = 3;
        while (i >= 0) {
            if (!sh_l[i].crossPos(sh_l[(i + 3) % 4], this.vertex[i])) {
                return false;
            }
            --i;
        }
        NyARRectTargetStatus.rotateVertexL(this.vertex, NyARRectTargetStatus.checkVertexShiftValue(i_prev_status.vertex, this.vertex));
        this.setEstimateParam(i_prev_status);
        return true;
    }

    public boolean setValueByAutoSelect(INyARVectorReader i_vec_reader, LowResolutionLabelingSamplerOut.Item i_source, NyARRectTargetStatus i_prev_status) throws NyARException {
        int current_detect_type = 1;
        int sq_v_ave_limit = i_prev_status.estimate_sum_sq_vertex_velocity_ave / 4;
        if (sq_v_ave_limit < 10 && i_prev_status.detect_type == 1 || i_prev_status.detect_type == 2) {
            current_detect_type = 2;
        }
        switch (current_detect_type) {
            case 2: {
                if (this.setValueByLineLog(i_vec_reader, i_prev_status)) {
                    this.detect_type = 2;
                    return true;
                }
                if (i_source == null || !this.setValueWithDeilyCheck(i_vec_reader, i_source, i_prev_status)) break;
                this.detect_type = 1;
                return true;
            }
            case 1: {
                if (i_source == null || !this.setValueWithDeilyCheck(i_vec_reader, i_source, i_prev_status)) break;
                this.detect_type = 1;
                return true;
            }
        }
        i_prev_status.detect_type = -1;
        return false;
    }

    private boolean checkInitialRectCondition(NyARIntRect i_sample_area) {
        NyARDoublePoint2d[] this_vx = this.vertex;
        int cx = (int)(this_vx[0].x + this_vx[1].x + this_vx[2].x + this_vx[3].x) / 4;
        int cy = (int)(this_vx[0].y + this_vx[1].y + this_vx[2].y + this_vx[3].y) / 4;
        if (!i_sample_area.isInnerPoint(cx, cy)) {
            return false;
        }
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < 4) {
            int t = (int)this_vx[i].sqDist(this_vx[(i + 1) % 4]);
            if (t > max) {
                max = t;
            }
            if (t < min) {
                min = t;
            }
            ++i;
        }
        if (max < 25 || min < 25) {
            return false;
        }
        return 100 * min / max >= 9;
    }

    private boolean checkDeilyRectCondition(NyARRectTargetStatus i_prev_st) {
        NyARDoublePoint2d[] this_vx = this.vertex;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < 4) {
            int t = (int)this_vx[i].sqDist(this_vx[(i + 1) % 4]);
            if (t > max) {
                max = t;
            }
            if (t < min) {
                min = t;
            }
            ++i;
        }
        if (max < 25 || min < 25) {
            return false;
        }
        if (100 * min / max < 9) {
            return false;
        }
        return this._ref_my_pool.checkLargeDiff(this_vx, i_prev_st.vertex);
    }

    private boolean traceSquareLine(INyARVectorReader i_reader, int i_edge_size, NyARRectTargetStatus i_prevsq, NyARLinear[] o_line) throws NyARException {
        VecLinearCoordinates vecpos = this._ref_my_pool._vecpos;
        NyARDoublePoint2d p1 = i_prevsq.estimate_vertex[0];
        int dist_limit = i_edge_size * i_edge_size;
        int i = 0;
        while (i < 4) {
            NyARDoublePoint2d p2 = i_prevsq.estimate_vertex[(i + 1) % 4];
            i_reader.traceLineWithClip(p1, p2, i_edge_size, vecpos);
            this._ref_my_pool._vecpos_op.margeResembleCoords(vecpos);
            int vid = vecpos.getMaxCoordIndex();
            if (vecpos.items[vid].getAbsVecCos(i_prevsq.vertex[i], i_prevsq.vertex[(i + 1) % 4]) < 0.9961) {
                return false;
            }
            double dist = vecpos.items[vid].sqDistBySegmentLineEdge(i_prevsq.vertex[i], i_prevsq.vertex[i]);
            if (!(dist < (double)dist_limit)) {
                return false;
            }
            o_line[i].setVectorWithNormalize(vecpos.items[vid]);
            p1 = p2;
            ++i;
        }
        return true;
    }

    private static final int checkVertexShiftValue(NyARDoublePoint2d[] i_vertex1, NyARDoublePoint2d[] i_vertex2) {
        assert (i_vertex1.length == 4 && i_vertex2.length == 4);
        int min_dist = Integer.MAX_VALUE;
        int min_index = 0;
        int i = 3;
        while (i >= 0) {
            int d = 0;
            int i2 = 3;
            while (i2 >= 0) {
                int xd = (int)(i_vertex1[i2].x - i_vertex2[(i2 + i) % 4].x);
                int yd = (int)(i_vertex1[i2].y - i_vertex2[(i2 + i) % 4].y);
                d += xd * xd + yd * yd;
                --i2;
            }
            if (min_dist > d) {
                min_dist = d;
                min_index = i;
            }
            --i;
        }
        return min_index;
    }

    private static final void rotateVertexL(NyARDoublePoint2d[] i_vertex, int i_shift) {
        assert (i_shift < 4);
        if (i_shift == 0) {
            return;
        }
        int ll = 4 - i_shift;
        int d = _gcd_table4[ll];
        int mk = (4 - ll) % 4;
        int i = 0;
        while (i < d) {
            int t1;
            NyARDoublePoint2d vertext = i_vertex[i];
            int j = 1;
            while (j < 4 / d) {
                t1 = (i + (j - 1) * mk) % 4;
                int t2 = (i + j * mk) % 4;
                i_vertex[t1] = i_vertex[t2];
                ++j;
            }
            t1 = (i + ll) % 4;
            i_vertex[t1] = vertext;
            ++i;
        }
    }

    public void shiftByArtkDirection(int i_dir) {
        NyARRectTargetStatus.rotateVertexL(this.estimate_vertex, i_dir);
        NyARRectTargetStatus.rotateVertexL(this.vertex, i_dir);
    }
}

