/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.utils.j2se;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;

public class NyARRasterImageIO {
    public static void copy(INyARRgbRaster i_in, BufferedImage o_out) throws NyARException {
        assert (i_in.getSize().isEqualSize(o_out.getWidth(), o_out.getHeight()));
        INyARRgbPixelReader reader = i_in.getRgbPixelReader();
        int[] rgb = new int[3];
        int y = o_out.getHeight() - 1;
        while (y >= 0) {
            int x = o_out.getWidth() - 1;
            while (x >= 0) {
                reader.getPixel(x, y, rgb);
                o_out.setRGB(x, y, rgb[0] << 16 | rgb[1] << 8 | rgb[2]);
                --x;
            }
            --y;
        }
    }

    public static void copy(NyARGrayscaleRaster i_in, BufferedImage o_out) throws NyARException {
        assert (i_in.getSize().isEqualSize(o_out.getWidth(), o_out.getHeight()));
        if (i_in.isEqualBufferType(262145)) {
            int[] buf = (int[])i_in.getBuffer();
            int w = o_out.getWidth();
            int h = o_out.getHeight();
            int y = h - 1;
            while (y >= 0) {
                int x = w - 1;
                while (x >= 0) {
                    int v = buf[x + y * w];
                    o_out.setRGB(x, y, v * 65793);
                    --x;
                }
                --y;
            }
        }
    }

    public static void copy(INyARRaster i_in, BufferedImage o_out) throws NyARException {
        assert (i_in.getSize().isEqualSize(o_out.getWidth(), o_out.getHeight()));
        if (i_in.isEqualBufferType(262146)) {
            int[] buf = (int[])i_in.getBuffer();
            int w = o_out.getWidth();
            int h = o_out.getHeight();
            int y = h - 1;
            while (y >= 0) {
                int x = w - 1;
                while (x >= 0) {
                    o_out.setRGB(x, y, buf[x + y * w] == 0 ? 0 : 0xFFFFFF);
                    --x;
                }
                --y;
            }
        }
    }

    public static void copy(NyARHistogram i_in, int i_l, int i_t, int i_h, Graphics i_g) throws NyARException {
        int max = 0;
        int i = 0;
        while (i < i_in.length) {
            max = max < i_in.data[i] ? i_in.data[i] : max;
            ++i;
        }
        if (max == 0) {
            return;
        }
        i = 0;
        while (i < i_in.length) {
            i_g.drawLine(i_l + i, i_t, i_l + i, i_h - i_h * i_in.data[i] / max);
            ++i;
        }
    }

    public static void copy(BufferedImage i_in, INyARRgbRaster o_out) throws NyARException {
        assert (o_out.getSize().isEqualSize(i_in.getWidth(), i_in.getHeight()));
        INyARRgbPixelReader reader = o_out.getRgbPixelReader();
        int[] rgb = new int[3];
        int y = i_in.getHeight() - 1;
        while (y >= 0) {
            int x = i_in.getWidth() - 1;
            while (x >= 0) {
                int pix = i_in.getRGB(x, y);
                rgb[0] = pix >> 16 & 0xFF;
                rgb[1] = pix >> 8 & 0xFF;
                rgb[2] = pix & 0xFF;
                reader.setPixel(x, y, rgb);
                --x;
            }
            --y;
        }
    }

    public static void copy(BufferedImage i_in, INyARRaster o_out) throws NyARException {
        assert (o_out.getSize().isEqualSize(i_in.getWidth(), i_in.getHeight()));
        if (o_out.isEqualBufferType(262146)) {
            int[] buf = (int[])o_out.getBuffer();
            int w = i_in.getWidth();
            int h = i_in.getHeight();
            int y = h - 1;
            while (y >= 0) {
                int x = w - 1;
                while (x >= 0) {
                    buf[x + y * w] = (i_in.getRGB(x, y) & 0xFFFFFF) > 0 ? 1 : 0;
                    --x;
                }
                --y;
            }
        }
    }
}

