/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core2.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_Edge
implements INyARRasterFilter {
    public void doFilter(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        INyARBufferReader in_buffer_reader = i_input.getBufferReader();
        INyARBufferReader out_buffer_reader = i_output.getBufferReader();
        assert (in_buffer_reader.isEqualBufferType(262145));
        assert (out_buffer_reader.isEqualBufferType(262145));
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        int[] out_buf = (int[])out_buffer_reader.getBuffer();
        int[] in_buf = (int[])in_buffer_reader.getBuffer();
        int bp = 0;
        NyARIntSize size = i_output.getSize();
        int y = 1;
        while (y < size.h) {
            int prev = 128;
            int x = 1;
            while (x < size.w) {
                int w = in_buf[y * size.w + x];
                out_buf[y * size.w + x] = (Math.abs(w - prev) + Math.abs(w - in_buf[(y - 1) * size.w + x])) / 2;
                prev = w;
                bp += 3;
                ++x;
            }
            ++y;
        }
    }
}

