package jp.ac.kyutech.ai.ylab.shiva.nativecapable.plugin.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * The "New" wizard page allows setting the container for the new project as
 * well as the source folder.
 */

public class NativeCapableJavaProjectNewWizardPage extends WizardPage {
	private Text projectNameText;

	private Text srcFolderText;

	private Text binFolderText;

	private Text libFolderText;

	private ISelection selection;

	/**
	 * Constructor for NyARToolkitProjectNewWizardPage.
	 * 
	 * @param pageName
	 */
	public NativeCapableJavaProjectNewWizardPage(ISelection selection) {
		super("wizardPage");
		setTitle("Project Initialization");
		setDescription("This wizard creates a new project for NyARToolkit with JMF and JOGE Support.");
		this.selection = selection;
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);

		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 2;
		layout.verticalSpacing = 9;
		Label label = new Label(container, SWT.NULL);
		label.setText("&Project name:");

		projectNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		projectNameText.setLayoutData(gd);
		projectNameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		label.setText("&Source folder:");

		srcFolderText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		srcFolderText.setLayoutData(gd);
		srcFolderText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		label.setText("&Binary folder:");

		binFolderText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		binFolderText.setLayoutData(gd);
		binFolderText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		label.setText("&Library folder:");

		libFolderText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		libFolderText.setLayoutData(gd);
		libFolderText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		initialize();
		dialogChanged();
		setControl(container);
	}

	/**
	 * Tests if the current workbench selection is a suitable container to use.
	 */

	private void initialize() {
		if (selection != null && selection.isEmpty() == false
				&& selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) selection;
			if (ssel.size() > 1)
				return;
			Object obj = ssel.getFirstElement();
			if (obj instanceof IResource) {
				IContainer container;
				if (obj instanceof IContainer)
					container = (IContainer) obj;
				else
					container = ((IResource) obj).getParent();
				projectNameText.setText(container.getFullPath().toString());
			}
		}
		srcFolderText.setText("src");
		binFolderText.setText("bin");
		libFolderText.setText("lib");
	}

	// /**
	// * Uses the standard container selection dialog to choose the new value
	// for
	// * the container field.
	// */
	//
	// private void handleBrowse() {
	// ContainerSelectionDialog dialog = new ContainerSelectionDialog(
	// getShell(), ResourcesPlugin.getWorkspace().getRoot(), false,
	// "Select new file container");
	// if (dialog.open() == ContainerSelectionDialog.OK) {
	// Object[] result = dialog.getResult();
	// if (result.length == 1) {
	// projectNameText.setText(((Path) result[0]).toString());
	// }
	// }
	// }

	/**
	 * Ensures that both text fields are set.
	 */
	private void dialogChanged() {
		IResource project = ResourcesPlugin.getWorkspace().getRoot()
				.findMember(new Path(getProjectName()));
		String srcFolderName = getSrcFolderName();
		String binFolderName = getBinFolderName();
		String libFolderName = getLibFolderName();

		if (getProjectName().length() == 0) {
			updateStatus("Project name must be specified");
			return;
		}
		if (project != null) {
			updateStatus("Project is duplicated");
			return;
		}

		if (srcFolderName.length() == 0) {
			updateStatus("Source folder must be specified");
			return;
		}
		if (srcFolderName.replace('\\', '/').indexOf('/', 1) > 0) {
			updateStatus("Source Folder name must be valid");
			return;
		}

		if (binFolderName.length() == 0) {
			updateStatus("Binary folder must be specified");
			return;
		}
		if (binFolderName.replace('\\', '/').indexOf('/', 1) > 0) {
			updateStatus("Binary Folder name must be valid");
			return;
		}

		if (libFolderName.length() == 0) {
			updateStatus("Library folder must be specified");
			return;
		}
		if (libFolderName.replace('\\', '/').indexOf('/', 1) > 0) {
			updateStatus("Library Folder name must be valid");
			return;
		}

		updateStatus(null);
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}

	public String getProjectName() {
		return projectNameText.getText();
	}

	public String getSrcFolderName() {
		return srcFolderText.getText();
	}

	public String getBinFolderName() {
		return binFolderText.getText();
	}

	public String getLibFolderName() {
		return libFolderText.getText();
	}
}