/* 
 * PROJECT: NyARToolkitCPP
 * --------------------------------------------------------------------------------
 *
 * The NyARToolkitCS is C++ version NyARToolkit class library.
 * 
 * Copyright (C)2009 R.Iizuka
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://nyatla.jp/nyatoolkit/
 *	<airmail(at)ebony.plala.or.jp>
 * 
 */
#include "NyARRgbRaster_RGB.h"
#include "nyarcore.h"
namespace NyARToolkitCPP
{
	NyARRgbRaster_RGB* NyARRgbRaster_RGB::wrap(const NyAR_BYTE_t* i_buffer, int i_width, int i_height)
	{
		return new NyARRgbRaster_RGB(i_buffer, i_width, i_height);
	}

	NyARRgbRaster_RGB::NyARRgbRaster_RGB(const NyAR_BYTE_t* i_buffer, int i_width, int i_height):NyARRgbRaster_BasicClass(i_width,i_height)
	{
		this->_ref_buf = i_buffer;
		this->_rgb_reader = new NyARRgbPixelReader_RGB24(&this->_size,i_buffer);
		this->_buffer_reader=new NyARBufferReader(i_buffer,INyARBufferReader::BUFFERFORMAT_BYTE1D_R8G8B8_24);
		return;
	}
	NyARRgbRaster_RGB::NyARRgbRaster_RGB(int i_width, int i_height):NyARRgbRaster_BasicClass(i_width,i_height)
	{
		this->_ref_buf =NULL;
		this->_rgb_reader = new NyARRgbPixelReader_RGB24(&this->_size,NULL);
		this->_buffer_reader=new NyARBufferReader(NULL,INyARBufferReader::BUFFERFORMAT_BYTE1D_B8G8R8X8_32);
		return;
	}

	NyARRgbRaster_RGB::~NyARRgbRaster_RGB(void)
	{
		NyAR_SAFE_DELETE(this->_rgb_reader);
		NyAR_SAFE_DELETE(this->_buffer_reader);
		return;
	}

	const INyARRgbPixelReader& NyARRgbRaster_RGB::getRgbPixelReader() const
	{
		return *(this->_rgb_reader);
	}
	const INyARBufferReader& NyARRgbRaster_RGB::getBufferReader() const
	{
		return *(this->_buffer_reader);
	}
	void NyARRgbRaster_RGB::setBuffer(const NyAR_BYTE_t* i_buffer)
	{
		NyAR_ASSERT(i_buffer!=NULL);
		this->_ref_buf=i_buffer;
		this->_buffer_reader->setBuffer(i_buffer);
	}

}

