/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#include "nyarcore.h"
#include "NyARRgbRaster_BGRA.h"
#include "NyARBufferReader.h"
#include <cstddef>
namespace NyARToolkitCPP
{


	NyARRgbRaster_BGRA::NyARRgbRaster_BGRA(const NyAR_BYTE_t* i_buffer, int i_width, int i_height):NyARRgbRaster_BasicClass(i_width,i_height)
	{
		this->_ref_buf = i_buffer;
		this->_rgb_reader = new PixelReader(this);
		this->_buffer_reader=new NyARBufferReader(i_buffer,INyARBufferReader::BUFFERFORMAT_BYTE1D_B8G8R8X8_32);
		return;
	}

	NyARRgbRaster_BGRA::~NyARRgbRaster_BGRA(void)
	{
		NyAR_SAFE_DELETE(this->_rgb_reader);
		NyAR_SAFE_DELETE(this->_buffer_reader);
		return;
	}

	const INyARRgbPixelReader& NyARRgbRaster_BGRA::getRgbPixelReader() const
	{
		return *(this->_rgb_reader);
	}
	const INyARBufferReader& NyARRgbRaster_BGRA::getBufferReader() const
	{
		return *(this->_buffer_reader);
	}

}
