/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#include "SingleARMarkerProcessor.h"
#include "nyarcore.h"
namespace NyARToolkitCPP
{
	/**
	* ̃NX́AɂP̃}[J邱Ƃ̂łAAvP[VvZbTłB
	* }[J̏oEړEłACxgŒʒm邱Ƃł܂B
	* NXɂ͕̃}[Jo^ł܂B̃}[JƁAvZbT͌pē}[J
	* PFA܂ł̊Ԃ͑̃}[JF܂B
	* 
	* CxǵA OnEnterOnUpdate[n]OnLeavȅŔ܂B
	* }[JƂ܂OnEnterPxāAԂ̃}[Jꂽ킩܂B
	* OnUpdateɂA݂̕ϊs񂪘Aēn܂BŌɃ}[JƁAOnLeave
	* Cxg܂B
	* 
	*/
	SingleARMarkerProcesser::SingleARMarkerProcesser()
	{
		this->_cf_threshold_new = 0.30;
		this->_cf_threshold_exist = 0.15;
		this->_threshold = 110;
		this->_current_arcode_index = -1;
		this->_lost_delay_count = 0;
		this->_lost_delay = 5;
		this->_square_list = new NyARSquareStack(100);
		this->_initialized=false;
		return;
	}
	SingleARMarkerProcesser::~SingleARMarkerProcesser()
	{
		//setARCodeTableŊ蓖ĂꂽIuWFNgJ
		freeARCodeTable();
		NyAR_SAFE_DELETE(this->_square_list);
		if(this->_initialized==true){
			//initInstanceŊ蓖ĂIuWFNgJ
			NyAR_SAFE_DELETE(this->_square_detect);
			NyAR_SAFE_DELETE(this->_transmat);
			NyAR_SAFE_DELETE(this->_bin_raster);
			NyAR_SAFE_DELETE(this->_tobin_filter);
			NyAR_SAFE_DELETE(this->_threshold_detect);
		}
		return;
	}
	void SingleARMarkerProcesser::initInstance(const NyARParam* i_param,int i_raster_type)
	{
		const TNyARIntSize& scr_size = i_param->getScreenSize();
		// ̓IuWFNg
		this->_square_detect = new NyARSquareDetector_Rle(i_param->getDistortionFactor(), scr_size);
		this->_transmat = new NyARTransMat(i_param);
		this->_tobin_filter=new NyARRasterFilter_ARToolkitThreshold(110,i_raster_type);

		// Ql摜obt@
		this->_bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
		this->_threshold_detect=new NyARRasterThresholdAnalyzer_SlidePTile(15,i_raster_type,4);
		//
		this->_patt=NULL;
		this->_deviation_data=NULL;
		this->_match_patt=NULL;
		this->_initialized=true;
		return;
	}

	void SingleARMarkerProcesser::freeARCodeTable()
	{
		//ς̃IuWFNg폜
		NyAR_SAFE_DELETE(this->_patt);
		NyAR_SAFE_DELETE(this->_deviation_data);
		if(this->_match_patt!=NULL){
			for(int i=0;i<this->_match_patt->length;i++){
				NyAR_SAFE_DELETE(this->_match_patt->item[i]);
			}
			NyAR_SAFE_DELETE(this->_match_patt);
		}
		return;
	}

	/*E蓮̐ݒ肪oȂ̂ŁARgAEg
	public void setThreshold(int i_threshold)
	{
	this._threshold = i_threshold;
	return;
	}*/

	/**o}[JR[h̔zw肵܂B oԂł̊֐sƁA
	* IuWFNgԂɋZbg܂B
	*/

	void SingleARMarkerProcesser::setARCodeTable(NyARCode* const i_ref_code_table[],int i_number_of_code, int i_code_resolution, double i_marker_width)
	{
		if (this->_current_arcode_index != -1) {
			// Zbg
			reset(true);
		}
		//ς̃IuWFNg폜
		freeARCodeTable();

		//o}[JZbgAAo蒼B(1sNZ4|CgTvO,}[J̃p^[̈50%)
		this->_patt = new NyARColorPatt_Perspective_O2(i_code_resolution, i_code_resolution,4,25);
		this->_deviation_data=new NyARMatchPattDeviationColorData(i_code_resolution, i_code_resolution);
		this->_marker_width = i_marker_width;

		this->_match_patt = new NyArray<NyARMatchPatt_Color_WITHOUT_PCA*>(i_number_of_code);
		for(int i=0;i<i_number_of_code;i++){
			this->_match_patt->item[i]=new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code_table[i]);
		}
		return;
	}

	void SingleARMarkerProcesser::reset(bool i_is_force)
	{
		if (this->_current_arcode_index != -1 && i_is_force == false) {
			// łȂ΃CxgR[
			this->onLeaveHandler();
		}
		// Jg}[JZbg
		this->_current_arcode_index = -1;
		return;
	}

	void SingleARMarkerProcesser::detectMarker(const INyARRgbRaster& i_raster)
	{
		// TCY`FbN
		NyAR_ASSERT(this->_bin_raster->getSize().isEqualSize(i_raster.getSize().w, i_raster.getSize().h));

		// R[he[u΂ŏI
		if (this->_match_patt== NULL) {
			return;
		}

		// X^(1/4̉摜)QlC[Wɕϊ.
		this->_tobin_filter->setThreshold(this->_threshold);
		this->_tobin_filter->doFilter(i_raster, *this->_bin_raster);

		NyARSquareStack& square_stack = *this->_square_list;
		// XNGAR[hT
		this->_square_detect->detectMarker(*this->_bin_raster, square_stack);
		// F
		if (this->_current_arcode_index == -1) { // }[JF
			detectNewMarker(i_raster, square_stack);
		} else { // }[JF
			detectExistMarker(i_raster, square_stack, this->_current_arcode_index);
		}
		return;
	}


	/**ARCodẽXgAłvR[hԍ܂B
	*/
	bool SingleARMarkerProcesser::selectARCodeIndexFromList(const INyARRgbRaster& i_raster,const NyARSquare& i_square, TResult_selectARCodeIndex& o_result)
	{
		// ݃R[he[u̓ANeBuH
		if (this->_match_patt==NULL) {
			return false;
		}
		// ]ɂȂp^[C[W؂o
		if (!this->_patt->pickFromRaster(i_raster, i_square)) {
			return false;
		}
		//]f[^쐬āA]ɃZbg
		this->_deviation_data->setRaster(*this->_patt);		
		TNyARMatchPattResult mr;
		int code_index = 0;
		int dir = 0;
		double c1 = 0;
		// R[hƔr
		for (int i = 0; i < this->_match_patt->length; i++) {
			this->_match_patt->item[i]->evaluate(*this->_deviation_data,mr);
			double c2 = mr.confidence;
			if (c1 < c2) {
				code_index = i;
				c1 = c2;
				dir = mr.direction;
			}
		}
		o_result.code_index = code_index;
		o_result.direction = dir;
		o_result.confidence = c1;
		return true;
	}

	/**VK}[J ݔF̃}[JȂ̂ƂāAłF₷}[JPF܂B
	*/
	void SingleARMarkerProcesser::detectNewMarker(const INyARRgbRaster& i_raster,NyARSquareStack& i_stack)
	{
		int number_of_square = i_stack.getLength();
		double cf = 0;
		int dir = 0;
		int code_index = -1;
		int square_index = 0;
		TResult_selectARCodeIndex detect_result;
		for (int i = 0; i < number_of_square; i++) {
			if (!selectARCodeIndexFromList(i_raster,*i_stack.getItem(i), detect_result)) {
				// ȂB
				return;
			}
			if (detect_result.confidence < this->_cf_threshold_new) {
				continue;
			}
			if (detect_result.confidence < cf) {
				// vxႢB
				continue;
			}
			cf = detect_result.confidence;
			code_index = detect_result.code_index;
			square_index = i;
			dir = detect_result.direction;
		}
		// FԂXV
		const bool is_id_found=updateStatus(*this->_square_list->getItem(square_index), code_index, cf, dir);
		//臒ltB[hobN(detectExistMarkerɂ)
		if(!is_id_found){
			//}[JȂ΁AT+DualPTailŊPx
			this->_threshold_detect->analyzeRaster(i_raster);
			this->_threshold=(this->_threshold+this->_threshold_detect->getThreshold())/2;
		}
	}

	/**}[J̌pF ݔF̃}[JD悵ĔF܂B 
	* ij̋@\͂Ԃ񍡌ア낢딭W邩NewƍȂƁB
	*/
	void SingleARMarkerProcesser::detectExistMarker(const INyARRgbRaster& i_raster,const NyARSquareStack& i_stack, int i_current_id)
	{
		int number_of_square = i_stack.getLength();
		double cf = 0;
		int dir = 0;
		int code_index = -1;
		int square_index = 0;
		TResult_selectARCodeIndex detect_result;
		for (int i = 0; i < number_of_square; i++) {
			if (!selectARCodeIndexFromList(i_raster,*i_stack.getItem(i), detect_result)) {
				// ȂB
				return;
			}
			// ݂̃}[JFH
			if (detect_result.code_index != i_current_id) {
				// F̃}[Jł͂Ȃ̂Ŗ
				continue;
			}
			if (detect_result.confidence < this->_cf_threshold_exist) {
				continue;
			}
			if (detect_result.confidence < cf) {
				// vxI
				continue;
			}
			cf = detect_result.confidence;
			code_index = detect_result.code_index;
			dir = detect_result.direction;
			square_index = i;
		}
		// FԂXV
		const bool is_id_found=updateStatus(*this->_square_list->getItem(square_index), code_index, cf, dir);
		//臒ltB[hobN(detectExistMarkerɂ)
		if(!is_id_found){
			//}[JȂ΁AT+DualPTailŊPx
			this->_threshold_detect->analyzeRaster(i_raster);
			this->_threshold=(this->_threshold+this->_threshold_detect->getThreshold())/2;
		}

	}

	/**	IuWFNg̃Xe[^XXVAKvɉănh֐쓮܂B
	* 	߂ĺAuۂɃ}[J𔭌鎖łvłBNX̏ԂƂ͈قȂ܂B
	*/
	bool SingleARMarkerProcesser::updateStatus(const NyARSquare& i_square, int i_code_index, double i_cf, int i_dir)
	{
		NyARTransMatResult& result = this->__NyARSquare_result;
		if (this->_current_arcode_index < 0) {// F
			if (i_code_index < 0) {// F疢F̑J
				// ȂɂȂ[B
				return false;
			} else {// FF̑J
				this->_current_arcode_index = i_code_index;
				// Cxg
				// OnEnter
				this->onEnterHandler(i_code_index);
				// ϊs쐬
				this->_transmat->transMat(i_square, i_dir, this->_marker_width, result);
				// OnUpdate
				this->onUpdateHandler(i_square, result);
				this->_lost_delay_count = 0;
				return true;
			}
		} else {// F
			if (i_code_index < 0) {// F疢F̑J
				this->_lost_delay_count++;
				if (this->_lost_delay < this->_lost_delay_count) {
					// OnLeave
					this->_current_arcode_index = -1;
					this->onLeaveHandler();
				}
				return false;
			} else if (i_code_index == this->_current_arcode_index) {// ARCode̍ĔF
				// Cxg
				// ϊs쐬
				this->_transmat->transMat(i_square, i_dir, this->_marker_width, result);
				// OnUpdate
				this->onUpdateHandler(i_square, result);
				this->_lost_delay_count = 0;
				return true;
			} else {// قȂR[h̔F̓T|[gȂB
				throw NyARException();
			}
		}
	}
}
