package java3d;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;

import javax.swing.WindowConstants;

import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapableModuleBuilder;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapableApplication;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapableModule;

public class Java3DTestApplication {
	public static void main(String[] args) {

		NativeCapableApplication nca = new NativeCapableApplication();

		NativeCapableModuleBuilder builder = new NativeCapableModuleBuilder(
				nca, "java3d.Java3DTestModule");

		Collection<String> col = new HashSet<String>();
		col.add("javax.media.j3d");
		builder.setTargetPackages(col);
		builder.setDelegateTargets(false);

		final NativeCapableModule module = builder.newModule();
		module.initModule();

		nca.add(module.getRootComponent());
		nca.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		nca.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				module.destroyModule();
			}
		});

		nca.setBounds(100, 100, 640, 480);
		nca.setVisible(true);

		module.startModule();
	}
}
