/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_Reverse
implements INyARRasterFilter {
    private IdoFilterImpl _do_filter_impl;

    public NyARRasterFilter_Reverse(int i_raster_type) throws NyARException {
        switch (i_raster_type) {
            case 262145: {
                this._do_filter_impl = new IdoFilterImpl_GRAY_8();
                break;
            }
            default: {
                throw new NyARException();
            }
        }
    }

    public void doFilter(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        this._do_filter_impl.doFilter(i_input, i_output, i_input.getSize());
    }

    static interface IdoFilterImpl {
        public void doFilter(INyARRaster var1, INyARRaster var2, NyARIntSize var3) throws NyARException;
    }

    class IdoFilterImpl_GRAY_8
    implements IdoFilterImpl {
        IdoFilterImpl_GRAY_8() {
        }

        public void doFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size) throws NyARException {
            assert (i_input.isEqualBufferType(262145));
            assert (i_output.isEqualBufferType(262145));
            int[] in_ptr = (int[])i_input.getBuffer();
            int[] out_ptr = (int[])i_output.getBuffer();
            int number_of_pixel = i_size.h * i_size.w;
            int i = 0;
            while (i < number_of_pixel) {
                out_ptr[i] = 255 - in_ptr[i];
                ++i;
            }
        }
    }
}

