/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.NyARRasterFilter_Rgb2Hsv;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class Rgb2HsvFilter_BYTE1D_B8G8R8_24
implements NyARRasterFilter_Rgb2Hsv.IFilter {
    Rgb2HsvFilter_BYTE1D_B8G8R8_24() {
    }

    @Override
    public final boolean isSupport(INyARRaster i_in, INyARRaster i_out) {
        return i_in.isEqualBufferType(65538) && i_out.isEqualBufferType(262403);
    }

    @Override
    public void doFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size) throws NyARException {
        assert (i_input.isEqualBufferType(262403));
        int[] out_buf = (int[])i_output.getBuffer();
        byte[] in_buf = (byte[])i_input.getBuffer();
        int i = i_size.h * i_size.w - 1;
        while (i >= 0) {
            int h;
            int s;
            int cmin;
            int cmax;
            int r = in_buf[i * 3 + 2] & 0xFF;
            int g = in_buf[i * 3 + 1] & 0xFF;
            int b = in_buf[i * 3 + 0] & 0xFF;
            if (r > g) {
                cmax = r;
                cmin = g;
            } else {
                cmax = g;
                cmin = r;
            }
            if (b > cmax) {
                cmax = b;
            }
            if (b < cmin) {
                cmin = b;
            }
            if (cmax == 0) {
                s = 0;
                h = 0;
            } else {
                s = (cmax - cmin) * 255 / cmax;
                int cdes = cmax - cmin;
                h = cdes != 0 ? (cmax == r ? (g - b) * 60 / cdes : (cmax == g ? (b - r) * 60 / cdes + 120 : (r - g) * 60 / cdes + 240)) : 0;
            }
            if (h < 0) {
                h += 360;
            }
            out_buf[i] = 0x1FF0000 & h << 16 | 0xFF00 & s << 8 | cmax & 0xFF;
            --i;
        }
    }
}

