/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.rotmatrix;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotVectorV2;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix33;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public class NyARRotMatrix
extends NyARDoubleMatrix33 {
    private final NyARRotVectorV2 __initRot_vec1;
    private final NyARRotVectorV2 __initRot_vec2;

    public NyARRotMatrix(NyARPerspectiveProjectionMatrix i_matrix) throws NyARException {
        this.__initRot_vec1 = new NyARRotVectorV2(i_matrix);
        this.__initRot_vec2 = new NyARRotVectorV2(i_matrix);
    }

    public final void initRotByPrevResult(NyARDoubleMatrix44 i_prev_result) {
        this.m00 = i_prev_result.m00;
        this.m01 = i_prev_result.m01;
        this.m02 = i_prev_result.m02;
        this.m10 = i_prev_result.m10;
        this.m11 = i_prev_result.m11;
        this.m12 = i_prev_result.m12;
        this.m20 = i_prev_result.m20;
        this.m21 = i_prev_result.m21;
        this.m22 = i_prev_result.m22;
    }

    public boolean initRotBySquare(NyARLinear[] i_linear, NyARDoublePoint2d[] i_sqvertex) {
        NyARRotVectorV2 vec1 = this.__initRot_vec1;
        NyARRotVectorV2 vec2 = this.__initRot_vec2;
        vec1.exteriorProductFromLinear(i_linear[0], i_linear[2]);
        if (!vec1.checkVectorByVertex(i_sqvertex[0], i_sqvertex[1])) {
            return false;
        }
        vec2.exteriorProductFromLinear(i_linear[1], i_linear[3]);
        if (!vec2.checkVectorByVertex(i_sqvertex[3], i_sqvertex[0])) {
            return false;
        }
        if (!NyARRotVectorV2.checkRotation(vec1, vec2)) {
            return false;
        }
        this.m00 = vec1.v1;
        this.m10 = vec1.v2;
        this.m20 = vec1.v3;
        this.m01 = vec2.v1;
        this.m11 = vec2.v2;
        this.m21 = vec2.v3;
        double w02 = vec1.v2 * vec2.v3 - vec1.v3 * vec2.v2;
        double w12 = vec1.v3 * vec2.v1 - vec1.v1 * vec2.v3;
        double w22 = vec1.v1 * vec2.v2 - vec1.v2 * vec2.v1;
        double w = Math.sqrt(w02 * w02 + w12 * w12 + w22 * w22);
        this.m02 = w02 / w;
        this.m12 = w12 / w;
        this.m22 = w22 / w;
        return true;
    }

    public final void initRotByAngle(NyARDoublePoint3d i_angle) {
        this.setZXYAngle(i_angle);
    }

    public final void getPoint3d(NyARDoublePoint3d i_in_point, NyARDoublePoint3d i_out_point) {
        double x = i_in_point.x;
        double y = i_in_point.y;
        double z = i_in_point.z;
        i_out_point.x = this.m00 * x + this.m01 * y + this.m02 * z;
        i_out_point.y = this.m10 * x + this.m11 * y + this.m12 * z;
        i_out_point.z = this.m20 * x + this.m21 * y + this.m22 * z;
    }

    public final void getPoint3dBatch(NyARDoublePoint3d[] i_in_point, NyARDoublePoint3d[] i_out_point, int i_number_of_vertex) {
        int i = i_number_of_vertex - 1;
        while (i >= 0) {
            NyARDoublePoint3d out_ptr = i_out_point[i];
            NyARDoublePoint3d in_ptr = i_in_point[i];
            double x = in_ptr.x;
            double y = in_ptr.y;
            double z = in_ptr.z;
            out_ptr.x = this.m00 * x + this.m01 * y + this.m02 * z;
            out_ptr.y = this.m10 * x + this.m11 * y + this.m12 * z;
            out_ptr.z = this.m20 * x + this.m21 * y + this.m22 * z;
            --i;
        }
    }
}

