/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types.stack;

import java.lang.reflect.Array;
import jp.nyatla.nyartoolkit.NyARException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NyARObjectStack<T> {
    protected final T[] _items;
    protected int _length;

    protected NyARObjectStack(int i_length, Class<T> i_element_type) throws NyARException {
        this._items = (Object[])Array.newInstance(i_element_type, i_length);
        int i = 0;
        while (i < i_length) {
            this._items[i] = this.createElement();
            ++i;
        }
        this._length = 0;
    }

    protected abstract T createElement();

    public final T prePush() {
        if (this._length >= this._items.length) {
            return null;
        }
        T ret = this._items[this._length];
        ++this._length;
        return ret;
    }

    public final void init(int i_reserv_length) throws NyARException {
        if (i_reserv_length >= this._items.length) {
            throw new NyARException();
        }
        this._length = i_reserv_length;
    }

    public final T pop() {
        assert (this._length >= 1);
        --this._length;
        return this._items[this._length];
    }

    public final void pops(int i_count) {
        assert (this._length >= i_count);
        this._length -= i_count;
    }

    public final T[] getArray() {
        return this._items;
    }

    public final T getItem(int i_index) {
        return this._items[i_index];
    }

    public final int getLength() {
        return this._length;
    }

    public final void clear() {
        this._length = 0;
    }
}

