/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.solver;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.solver.INyARTransportVectorSolver;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;

public class NyARTransportVectorSolver
implements INyARTransportVectorSolver {
    private double[] _cx;
    private double[] _cy;
    private final NyARPerspectiveProjectionMatrix _projection_mat;
    private int _nmber_of_vertex;
    private double _a00;
    private double _a01_10;
    private double _a02_20;
    private double _a11;
    private double _a12_21;
    private double _a22;

    public NyARTransportVectorSolver(NyARPerspectiveProjectionMatrix i_projection_mat_ref, int i_max_vertex) {
        this._projection_mat = i_projection_mat_ref;
        this._cx = new double[i_max_vertex];
        this._cy = new double[i_max_vertex];
    }

    @Override
    public void set2dVertex(NyARDoublePoint2d[] i_ref_vertex_2d, int i_number_of_vertex) throws NyARException {
        double[] cx = this._cx;
        double[] cy = this._cy;
        double p00 = this._projection_mat.m00;
        double p01 = this._projection_mat.m01;
        double p11 = this._projection_mat.m11;
        double p12 = this._projection_mat.m12;
        double p02 = this._projection_mat.m02;
        this._a00 = (double)i_number_of_vertex * p00 * p00;
        this._a01_10 = (double)i_number_of_vertex * p00 * p01;
        this._a11 = (double)i_number_of_vertex * (p01 * p01 + p11 * p11);
        double m22 = 0.0;
        double w2 = 0.0;
        double w1 = 0.0;
        int i = 0;
        while (i < i_number_of_vertex) {
            cx[i] = i_ref_vertex_2d[i].x;
            double w3 = p02 - cx[i];
            cy[i] = i_ref_vertex_2d[i].y;
            double w4 = p12 - cy[i];
            w1 += w3;
            w2 += w4;
            m22 += w3 * w3 + w4 * w4;
            ++i;
        }
        this._a02_20 = w1 * p00;
        this._a12_21 = p01 * w1 + p11 * w2;
        this._a22 = m22;
        this._nmber_of_vertex = i_number_of_vertex;
    }

    @Override
    public void solveTransportVector(NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint3d o_transfer) throws NyARException {
        int number_of_vertex = this._nmber_of_vertex;
        double p00 = this._projection_mat.m00;
        double p01 = this._projection_mat.m01;
        double p02 = this._projection_mat.m02;
        double p11 = this._projection_mat.m11;
        double p12 = this._projection_mat.m12;
        double[] cx = this._cx;
        double[] cy = this._cy;
        double b1 = 0.0;
        double b2 = 0.0;
        double b3 = 0.0;
        int i = 0;
        while (i < number_of_vertex) {
            double w1 = i_vertex3d[i].z * cx[i] - p00 * i_vertex3d[i].x - p01 * i_vertex3d[i].y - p02 * i_vertex3d[i].z;
            double w2 = i_vertex3d[i].z * cy[i] - p11 * i_vertex3d[i].y - p12 * i_vertex3d[i].z;
            b1 += w1;
            b2 += w2;
            b3 += cx[i] * w1 + cy[i] * w2;
            ++i;
        }
        b3 = p02 * b1 + p12 * b2 - b3;
        b2 = p01 * b1 + p11 * b2;
        b1 = p00 * b1;
        double a00 = this._a00;
        double a01 = this._a01_10;
        double a02 = this._a02_20;
        double a11 = this._a11;
        double a12 = this._a12_21;
        double a22 = this._a22;
        double t1 = a22 * b2 - a12 * b3;
        double t2 = a12 * b2 - a11 * b3;
        double t3 = a01 * b3 - a02 * b2;
        double t4 = a12 * a12 - a11 * a22;
        double t5 = a02 * a12 - a01 * a22;
        double t6 = a02 * a11 - a01 * a12;
        double det = a00 * t4 - a01 * t5 + a02 * t6;
        o_transfer.x = (a01 * t1 - a02 * t2 + b1 * t4) / det;
        o_transfer.y = -(a00 * t1 + a02 * t3 + b1 * t5) / det;
        o_transfer.z = (a00 * t2 + a01 * t3 + b1 * t6) / det;
    }
}

