/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARMatchPattDeviationColorData {
    private int[] _data;
    private double _pow;
    private NyARIntSize _size;
    private int _optimize_for_mod;

    public int[] refData() {
        return this._data;
    }

    public double getPow() {
        return this._pow;
    }

    public NyARMatchPattDeviationColorData(int i_width, int i_height) {
        this._size = new NyARIntSize(i_width, i_height);
        int number_of_pix = this._size.w * this._size.h;
        this._data = new int[number_of_pix * 3];
        this._optimize_for_mod = number_of_pix - number_of_pix % 8;
    }

    public void setRaster(INyARRgbRaster i_raster) throws NyARException {
        assert (i_raster.getSize().isEqualSize(this._size));
        switch (i_raster.getBufferType()) {
            case 262402: {
                this._pow = NyARMatchPattDeviationColorData.setRaster_INT1D_X8R8G8B8_32((int[])i_raster.getBuffer(), this._size.w * this._size.h, this._optimize_for_mod, this._data);
                break;
            }
            default: {
                this._pow = NyARMatchPattDeviationColorData.setRaster_ANY(i_raster.getRgbPixelReader(), this._size, this._size.w * this._size.h, this._data);
            }
        }
    }

    public final void setRaster(INyARRgbRaster i_raster, int i_direction) throws NyARException {
        int width = this._size.w;
        int height = this._size.h;
        int i_number_of_pix = width * height;
        INyARRgbPixelReader reader = i_raster.getRgbPixelReader();
        int[] rgb = new int[3];
        int[] dout = this._data;
        int ave = 0;
        int y = height - 1;
        while (y >= 0) {
            int x = width - 1;
            while (x >= 0) {
                reader.getPixel(x, y, rgb);
                ave += rgb[0] + rgb[1] + rgb[2];
                --x;
            }
            --y;
        }
        ave = i_number_of_pix * 255 * 3 - ave;
        ave = 255 - ave / (i_number_of_pix * 3);
        int sum = 0;
        int input_ptr = i_number_of_pix * 3 - 1;
        switch (i_direction) {
            case 0: {
                int w_sum;
                int y2 = height - 1;
                while (y2 >= 0) {
                    int x = width - 1;
                    while (x >= 0) {
                        reader.getPixel(x, y2, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        --x;
                    }
                    --y2;
                }
                break;
            }
            case 1: {
                int w_sum;
                int x = 0;
                while (x < width) {
                    int y3 = height - 1;
                    while (y3 >= 0) {
                        reader.getPixel(x, y3, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        --y3;
                    }
                    ++x;
                }
                break;
            }
            case 2: {
                int w_sum;
                int y2 = 0;
                while (y2 < height) {
                    int x = 0;
                    while (x < width) {
                        reader.getPixel(x, y2, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        ++x;
                    }
                    ++y2;
                }
                break;
            }
            case 3: {
                int w_sum;
                int x = width - 1;
                while (x >= 0) {
                    int y4 = 0;
                    while (y4 < height) {
                        reader.getPixel(x, y4, rgb);
                        w_sum = ave - rgb[2];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[1];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        w_sum = ave - rgb[0];
                        dout[input_ptr--] = w_sum;
                        sum += w_sum * w_sum;
                        ++y4;
                    }
                    --x;
                }
                break;
            }
        }
        double p = Math.sqrt(sum);
        this._pow = p != 0.0 ? p : 1.0E-7;
    }

    private static final double setRaster_INT1D_X8R8G8B8_32(int[] i_buf, int i_number_of_pix, int i_for_mod, int[] o_out) {
        int w_sum;
        int rgb;
        int ave = 0;
        int i = i_number_of_pix - 1;
        while (i >= i_for_mod) {
            rgb = i_buf[i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            --i;
        }
        while (i >= 0) {
            rgb = i_buf[i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            rgb = i_buf[--i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            rgb = i_buf[--i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            rgb = i_buf[--i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            rgb = i_buf[--i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            rgb = i_buf[--i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            rgb = i_buf[--i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            rgb = i_buf[--i];
            ave += (rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF);
            --i;
        }
        ave = i_number_of_pix * 255 * 3 - ave;
        ave = 255 - ave / (i_number_of_pix * 3);
        int sum = 0;
        int input_ptr = i_number_of_pix * 3 - 1;
        i = i_number_of_pix - 1;
        while (i >= i_for_mod) {
            rgb = i_buf[i];
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            --i;
        }
        while (i >= 0) {
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            rgb = i_buf[i];
            --i;
            w_sum = ave - (rgb & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 8 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
            w_sum = ave - (rgb >> 16 & 0xFF);
            o_out[input_ptr--] = w_sum;
            sum += w_sum * w_sum;
        }
        double p = Math.sqrt(sum);
        return p != 0.0 ? p : 1.0E-7;
    }

    private static final double setRaster_ANY(INyARRgbPixelReader i_reader, NyARIntSize i_size, int i_number_of_pix, int[] o_out) throws NyARException {
        int width = i_size.w;
        int[] rgb = new int[3];
        int ave = 0;
        int y = i_size.h - 1;
        while (y >= 0) {
            int x = width - 1;
            while (x >= 0) {
                i_reader.getPixel(x, y, rgb);
                ave += rgb[0] + rgb[1] + rgb[2];
                --x;
            }
            --y;
        }
        ave = i_number_of_pix * 255 * 3 - ave;
        ave = 255 - ave / (i_number_of_pix * 3);
        int sum = 0;
        int input_ptr = i_number_of_pix * 3 - 1;
        int y2 = i_size.h - 1;
        while (y2 >= 0) {
            int x = width - 1;
            while (x >= 0) {
                i_reader.getPixel(x, y2, rgb);
                int w_sum = ave - rgb[2];
                o_out[input_ptr--] = w_sum;
                sum += w_sum * w_sum;
                w_sum = ave - rgb[1];
                o_out[input_ptr--] = w_sum;
                sum += w_sum * w_sum;
                w_sum = ave - rgb[0];
                o_out[input_ptr--] = w_sum;
                sum += w_sum * w_sum;
                --x;
            }
            --y2;
        }
        double p = Math.sqrt(sum);
        return p != 0.0 ? p : 1.0E-7;
    }
}

