/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_SimpleSmooth
implements INyARRasterFilter {
    private IdoFilterImpl _do_filter_impl;

    public NyARRasterFilter_SimpleSmooth(int i_raster_type) throws NyARException {
        switch (i_raster_type) {
            case 262145: {
                this._do_filter_impl = new IdoFilterImpl_GRAY_8();
                break;
            }
            default: {
                throw new NyARException();
            }
        }
    }

    @Override
    public void doFilter(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        assert (i_input != i_output);
        this._do_filter_impl.doFilter(i_input, i_output, i_input.getSize());
    }

    protected static interface IdoFilterImpl {
        public void doFilter(INyARRaster var1, INyARRaster var2, NyARIntSize var3) throws NyARException;
    }

    private class IdoFilterImpl_GRAY_8
    implements IdoFilterImpl {
        private IdoFilterImpl_GRAY_8() {
        }

        @Override
        public void doFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size) throws NyARException {
            int col0;
            assert (i_input.isEqualBufferType(262145));
            assert (i_output.isEqualBufferType(262145));
            int[] in_ptr = (int[])i_input.getBuffer();
            int[] out_ptr = (int[])i_output.getBuffer();
            int width = i_size.w;
            int height = i_size.h;
            int bptr = 0;
            int col1 = in_ptr[bptr] + in_ptr[bptr + width];
            int col2 = in_ptr[bptr + 1] + in_ptr[bptr + width + 1];
            out_ptr[bptr] = (col1 + col2) / 4;
            ++bptr;
            int x = 0;
            while (x < width - 2) {
                col0 = col1;
                col1 = col2;
                col2 = in_ptr[bptr + 1] + in_ptr[bptr + width + 1];
                out_ptr[bptr] = (col0 + col1 + col2) / 6;
                ++bptr;
                ++x;
            }
            out_ptr[bptr] = (col1 + col2) / 4;
            ++bptr;
            int y = 0;
            while (y < height - 2) {
                col1 = in_ptr[bptr] + in_ptr[bptr - width] + in_ptr[bptr + width];
                col2 = in_ptr[bptr + 1] + in_ptr[bptr - width + 1] + in_ptr[bptr + width + 1];
                out_ptr[bptr] = (col1 + col2) / 6;
                ++bptr;
                int x2 = 0;
                while (x2 < width - 2) {
                    col0 = col1;
                    col1 = col2;
                    col2 = in_ptr[bptr + 1] + in_ptr[bptr - width + 1] + in_ptr[bptr + width + 1];
                    out_ptr[bptr] = (col0 + col1 + col2) / 9;
                    ++bptr;
                    ++x2;
                }
                out_ptr[bptr] = (col1 + col2) / 6;
                ++bptr;
                ++y;
            }
            col1 = in_ptr[bptr] + in_ptr[bptr - width];
            col2 = in_ptr[bptr + 1] + in_ptr[bptr - width + 1];
            out_ptr[bptr] = (col1 + col2) / 4;
            ++bptr;
            x = 0;
            while (x < width - 2) {
                col0 = col1;
                col1 = col2;
                col2 = in_ptr[bptr + 1] + in_ptr[bptr - width + 1];
                out_ptr[bptr] = (col0 + col1 + col2) / 6;
                ++bptr;
                ++x;
            }
            out_ptr[bptr] = (col1 + col2) / 4;
            ++bptr;
        }
    }
}

