/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.tracker.nyartk;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.rpf.sampler.lrlabel.LowResolutionLabelingSampler;
import jp.nyatla.nyartoolkit.rpf.sampler.lrlabel.LowResolutionLabelingSamplerOut;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NegativeSqRoberts;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTrackerSource;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARVectorReader_INT1D_GRAY_8;

public class NyARTrackerSource_Reference
extends NyARTrackerSource {
    private LowResolutionLabelingSampler _sampler;
    private NyARGrayscaleRaster _rb_source;
    private NegativeSqRoberts _rfilter = new NegativeSqRoberts(262145);

    public NyARTrackerSource_Reference(int i_number_of_sample, NyARCameraDistortionFactor i_ref_raster_distortion, int i_width, int i_height, int i_depth, boolean i_is_alloc) throws NyARException {
        super((int)Math.pow(2.0, i_depth));
        assert (i_depth > 0);
        int div = this._rob_resolution;
        this._base_raster = new NyARGrayscaleRaster(i_width, i_height, 262145, i_is_alloc);
        this._rb_source = new NyARGrayscaleRaster(i_width / div, i_height / div, 262145, true);
        this._rbraster = new NyARGrayscaleRaster(i_width / div, i_height / div, 262145, true);
        this._vec_reader = new NyARVectorReader_INT1D_GRAY_8(this._base_raster, i_ref_raster_distortion, this._rbraster);
        this._sampler = new LowResolutionLabelingSampler(i_width, i_height, (int)Math.pow(2.0, i_depth));
        this._sample_out = new LowResolutionLabelingSamplerOut(i_number_of_sample);
    }

    public void wrapBuffer(NyARGrayscaleRaster i_ref_source) throws NyARException {
        this._base_raster.wrapBuffer(i_ref_source.getBuffer());
    }

    @Override
    public void syncResource() throws NyARException {
        this._base_raster.copyTo(0, 0, this._rob_resolution, this._rb_source);
        this._rfilter.doFilter(this._rb_source, this._rbraster);
    }

    @Override
    public LowResolutionLabelingSamplerOut makeSampleOut() throws NyARException {
        this.syncResource();
        this._sampler.sampling(this._rbraster, 220, this._sample_out);
        return this._sample_out;
    }
}

