/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_CustomToneTable
implements INyARRasterFilter {
    protected final int[] table = new int[256];
    private IdoFilterImpl _dofilterimpl;

    protected NyARRasterFilter_CustomToneTable(int i_raster_type) throws NyARException {
        switch (i_raster_type) {
            case 262145: {
                this._dofilterimpl = new IdoFilterImpl_INT1D_GRAY_8();
                break;
            }
            default: {
                throw new NyARException();
            }
        }
        this._dofilterimpl._table_ref = this.table;
    }

    @Override
    public void doFilter(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        this._dofilterimpl.doFilter(i_input, i_output, i_input.getSize());
    }

    private abstract class IdoFilterImpl {
        public int[] _table_ref;

        private IdoFilterImpl() {
        }

        public abstract void doFilter(INyARRaster var1, INyARRaster var2, NyARIntSize var3) throws NyARException;
    }

    private class IdoFilterImpl_INT1D_GRAY_8
    extends IdoFilterImpl {
        private IdoFilterImpl_INT1D_GRAY_8() {
        }

        @Override
        public void doFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size) throws NyARException {
            assert (i_input.isEqualBufferType(262145));
            int[] out_buf = (int[])i_output.getBuffer();
            int[] in_buf = (int[])i_input.getBuffer();
            int i = i_size.h * i_size.w - 1;
            while (i >= 0) {
                out_buf[i] = this._table_ref[in_buf[i]];
                --i;
            }
        }
    }
}

