/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;

public class NyARSquare {
    public NyARLinear[] line = NyARLinear.createArray(4);
    public NyARDoublePoint2d[] sqvertex = NyARDoublePoint2d.createArray(4);
    private static final int[] _gcd_table4 = new int[]{-1, 1, 2, 1};

    public void getCenter2d(NyARDoublePoint2d o_out) {
        o_out.x = (this.sqvertex[0].x + this.sqvertex[1].x + this.sqvertex[2].x + this.sqvertex[3].x) / 4.0;
        o_out.y = (this.sqvertex[0].y + this.sqvertex[1].y + this.sqvertex[2].y + this.sqvertex[3].y) / 4.0;
    }

    public int checkVertexShiftValue(NyARSquare i_square) {
        NyARDoublePoint2d[] a = this.sqvertex;
        NyARDoublePoint2d[] b = i_square.sqvertex;
        int min_dist = Integer.MAX_VALUE;
        int min_index = 0;
        int i = 3;
        while (i >= 0) {
            int d = 0;
            int i2 = 3;
            while (i2 >= 0) {
                int xd = (int)(a[i2].x - b[(i2 + i) % 4].x);
                int yd = (int)(a[i2].y - b[(i2 + i) % 4].y);
                d += xd * xd + yd * yd;
                --i2;
            }
            if (min_dist > d) {
                min_dist = d;
                min_index = i;
            }
            --i;
        }
        return min_index;
    }

    public void rotateVertexL(int i_shift) {
        assert (i_shift < 4);
        if (i_shift == 0) {
            return;
        }
        int ll = 4 - i_shift;
        int d = _gcd_table4[ll];
        int mk = (4 - ll) % 4;
        int i = 0;
        while (i < d) {
            int t1;
            NyARLinear linet = this.line[i];
            NyARDoublePoint2d vertext = this.sqvertex[i];
            int j = 1;
            while (j < 4 / d) {
                t1 = (i + (j - 1) * mk) % 4;
                int t2 = (i + j * mk) % 4;
                this.line[t1] = this.line[t2];
                this.sqvertex[t1] = this.sqvertex[t2];
                ++j;
            }
            t1 = (i + ll) % 4;
            this.line[t1] = linet;
            this.sqvertex[t1] = vertext;
            ++i;
        }
    }
}

