/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.nyidmarker;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.nyidmarker.MarkerPattEncoder;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerParam;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;
import jp.nyatla.nyartoolkit.nyidmarker.PerspectivePixelReader;

public class NyIdMarkerPickup {
    private PerspectivePixelReader _perspective_reader;
    private final PerspectivePixelReader.TThreshold __pickFromRaster_th = new PerspectivePixelReader.TThreshold();
    private final MarkerPattEncoder __pickFromRaster_encoder = new MarkerPattEncoder();

    public NyIdMarkerPickup() {
        this._perspective_reader = new PerspectivePixelReader();
    }

    public final boolean pickFromRaster(INyARRgbRaster image, NyARDoublePoint2d[] i_vertex, NyIdMarkerPattern o_data, NyIdMarkerParam o_param) throws NyARException {
        if (!this._perspective_reader.setSourceSquare(i_vertex)) {
            return false;
        }
        return this._pickFromRaster(image, o_data, o_param);
    }

    public final boolean pickFromRaster(INyARRgbRaster image, NyARIntPoint2d[] i_vertex, NyIdMarkerPattern o_data, NyIdMarkerParam o_param) throws NyARException {
        if (!this._perspective_reader.setSourceSquare(i_vertex)) {
            return false;
        }
        return this._pickFromRaster(image, o_data, o_param);
    }

    private final boolean _pickFromRaster(INyARRgbRaster image, NyIdMarkerPattern o_data, NyIdMarkerParam o_param) throws NyARException {
        INyARRgbPixelReader reader = image.getRgbPixelReader();
        NyARIntSize raster_size = image.getSize();
        PerspectivePixelReader.TThreshold th = this.__pickFromRaster_th;
        MarkerPattEncoder encoder = this.__pickFromRaster_encoder;
        this._perspective_reader.detectThresholdValue(reader, raster_size, th);
        if (!this._perspective_reader.readDataBits(reader, raster_size, th, encoder)) {
            return false;
        }
        int d = encoder.encode(o_data);
        if (d < 0) {
            return false;
        }
        o_param.direction = d;
        o_param.threshold = th.th;
        return true;
    }
}

