/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.nyidmarker;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARGsPixelDriver;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.nyidmarker.MarkerPattEncoder;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerParam;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;
import jp.nyatla.nyartoolkit.nyidmarker.PerspectivePixelReader;

public class NyIdMarkerPickup {
    private PerspectivePixelReader _perspective_reader;
    private final PerspectivePixelReader.TThreshold __pickFromRaster_th = new PerspectivePixelReader.TThreshold();
    private final MarkerPattEncoder __pickFromRaster_encoder = new MarkerPattEncoder();

    public NyIdMarkerPickup() throws NyARException {
        this._perspective_reader = new PerspectivePixelReader();
    }

    public final boolean pickFromRaster(INyARGsPixelDriver i_pix_drv, NyARIntPoint2d[] i_vertex, NyIdMarkerPattern o_data, NyIdMarkerParam o_param) throws NyARException {
        if (!this._perspective_reader.setSourceSquare(i_vertex)) {
            return false;
        }
        return this._pickFromRaster(i_pix_drv, o_data, o_param);
    }

    public final boolean pickFromRaster(INyARGsPixelDriver i_pix_drv, NyARDoublePoint2d[] i_vertex, NyIdMarkerPattern o_data, NyIdMarkerParam o_param) throws NyARException {
        if (!this._perspective_reader.setSourceSquare(i_vertex)) {
            return false;
        }
        return this._pickFromRaster(i_pix_drv, o_data, o_param);
    }

    private boolean _pickFromRaster(INyARGsPixelDriver i_pix_drv, NyIdMarkerPattern o_data, NyIdMarkerParam o_param) throws NyARException {
        PerspectivePixelReader.TThreshold th = this.__pickFromRaster_th;
        MarkerPattEncoder encoder = this.__pickFromRaster_encoder;
        this._perspective_reader.detectThresholdValue(i_pix_drv, th);
        if (!this._perspective_reader.readDataBits(i_pix_drv, i_pix_drv.getSize(), th, encoder)) {
            return false;
        }
        int d = encoder.encode(o_data);
        if (d < 0) {
            return false;
        }
        o_param.direction = d;
        o_param.threshold = th.th;
        return true;
    }
}

