/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARTransRot_OptimizeCommon;

class NyARTransRot_O2
extends NyARTransRot_OptimizeCommon {
    private double CACA;
    private double SASA;
    private double SACA;
    private double CA;
    private double SA;
    private double CACACB;
    private double SACACB;
    private double SASACB;
    private double CASB;
    private double SASB;
    private final double[][] wk_initRot_wdir = new double[3][3];
    private final double[] wk_arModifyMatrix_combo = new double[12];
    private final double[] wk_arModifyMatrix_abc = new double[3];
    private final double[] wk_arModifyMatrix_rot = new double[9];

    public NyARTransRot_O2(NyARParam i_param, int i_number_of_vertex) throws NyARException {
        super(i_param, i_number_of_vertex);
    }

    public final void arGetRotA(double a) {
        double sina = Math.sin(a);
        double cosa = Math.cos(a);
        this.CACA = cosa * cosa;
        this.SASA = sina * sina;
        this.SACA = sina * cosa;
        this.CA = cosa;
        this.SA = sina;
    }

    public final void arGetRotB(double b, double[] o_rot) {
        double sinb = Math.sin(b);
        double cosb = Math.cos(b);
        this.CACACB = this.CACA * cosb;
        this.SACACB = this.SACA * cosb;
        this.SASACB = this.SASA * cosb;
        this.CASB = this.CA * sinb;
        this.SASB = this.SA * sinb;
        o_rot[2] = this.CASB;
        o_rot[5] = this.SASB;
        o_rot[8] = cosb;
    }

    public final void arGetRotC(double c, double[] o_rot) {
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        double SACASC = this.SACA * sinc;
        double SACACC = this.SACA * cosc;
        double SACACBSC = this.SACACB * sinc;
        double SACACBCC = this.SACACB * cosc;
        o_rot[0] = this.CACACB * cosc + this.SASA * cosc + SACACBSC - SACASC;
        o_rot[1] = -this.CACACB * sinc - this.SASA * sinc + SACACBCC - SACACC;
        o_rot[3] = SACACBCC - SACACC + this.SASACB * sinc + this.CACA * sinc;
        o_rot[4] = -SACACBSC + SACASC + this.SASACB * cosc + this.CACA * cosc;
        o_rot[6] = -this.CASB * cosc - this.SASB * sinc;
        o_rot[7] = this.CASB * sinc - this.SASB * cosc;
    }

    @Override
    public void initRot(NyARSquare marker_info, int i_direction) throws NyARException {
        double w;
        double[] cpara = this.cparam.get34Array();
        double[][] wdir = this.wk_initRot_wdir;
        int dir = i_direction;
        for (int j = 0; j < 2; ++j) {
            double w1 = marker_info.line[(4 - dir + j) % 4][0] * marker_info.line[(6 - dir + j) % 4][1] - marker_info.line[(6 - dir + j) % 4][0] * marker_info.line[(4 - dir + j) % 4][1];
            double w2 = marker_info.line[(4 - dir + j) % 4][1] * marker_info.line[(6 - dir + j) % 4][2] - marker_info.line[(6 - dir + j) % 4][1] * marker_info.line[(4 - dir + j) % 4][2];
            double w3 = marker_info.line[(4 - dir + j) % 4][2] * marker_info.line[(6 - dir + j) % 4][0] - marker_info.line[(6 - dir + j) % 4][2] * marker_info.line[(4 - dir + j) % 4][0];
            wdir[j][0] = w1 * (cpara[1] * cpara[6] - cpara[2] * cpara[5]) + w2 * cpara[5] - w3 * cpara[1];
            wdir[j][1] = -w1 * cpara[0] * cpara[6] + w3 * cpara[0];
            wdir[j][2] = w1 * cpara[0] * cpara[5];
            w = Math.sqrt(wdir[j][0] * wdir[j][0] + wdir[j][1] * wdir[j][1] + wdir[j][2] * wdir[j][2]);
            double[] dArray = wdir[j];
            dArray[0] = dArray[0] / w;
            double[] dArray2 = wdir[j];
            dArray2[1] = dArray2[1] / w;
            double[] dArray3 = wdir[j];
            dArray3[2] = dArray3[2] / w;
        }
        this.check_dir(wdir[0], marker_info.sqvertex[(4 - dir) % 4], marker_info.sqvertex[(5 - dir) % 4], cpara);
        this.check_dir(wdir[1], marker_info.sqvertex[(7 - dir) % 4], marker_info.sqvertex[(4 - dir) % 4], cpara);
        NyARTransRot_O2.check_rotation(wdir);
        wdir[2][0] = wdir[0][1] * wdir[1][2] - wdir[0][2] * wdir[1][1];
        wdir[2][1] = wdir[0][2] * wdir[1][0] - wdir[0][0] * wdir[1][2];
        wdir[2][2] = wdir[0][0] * wdir[1][1] - wdir[0][1] * wdir[1][0];
        w = Math.sqrt(wdir[2][0] * wdir[2][0] + wdir[2][1] * wdir[2][1] + wdir[2][2] * wdir[2][2]);
        double[] dArray = wdir[2];
        dArray[0] = dArray[0] / w;
        double[] dArray4 = wdir[2];
        dArray4[1] = dArray4[1] / w;
        double[] dArray5 = wdir[2];
        dArray5[2] = dArray5[2] / w;
        double[] rot = this.array;
        rot[0] = wdir[0][0];
        rot[3] = wdir[0][1];
        rot[6] = wdir[0][2];
        rot[1] = wdir[1][0];
        rot[4] = wdir[1][1];
        rot[7] = wdir[1][2];
        rot[2] = wdir[2][0];
        rot[5] = wdir[2][1];
        rot[8] = wdir[2][2];
    }

    @Override
    public double modifyMatrix(double[] trans, double[][] vertex, double[][] pos2d) throws NyARException {
        int num = this.number_of_vertex;
        double ma = 0.0;
        double mb = 0.0;
        double mc = 0.0;
        double minerr = 0.0;
        int s1 = 0;
        int s2 = 0;
        int s3 = 0;
        double[] combo = this.wk_arModifyMatrix_combo;
        double[] abc = this.wk_arModifyMatrix_abc;
        double[] rot = this.wk_arModifyMatrix_rot;
        this.arGetAngle(abc);
        double a2 = abc[0];
        double b2 = abc[1];
        double c2 = abc[2];
        double factor = 0.17453292519943295;
        this.nyatla_arGetNewMatrix_row3(trans, combo);
        for (int j = 0; j < 10; ++j) {
            minerr = 1.0E9;
            for (int t1 = -1; t1 <= 1; ++t1) {
                double a1 = a2 + factor * (double)t1;
                this.arGetRotA(a1);
                for (int t2 = -1; t2 <= 1; ++t2) {
                    double b1 = b2 + factor * (double)t2;
                    this.arGetRotB(b1, rot);
                    for (int t3 = -1; t3 <= 1; ++t3) {
                        double c1 = c2 + factor * (double)t3;
                        this.arGetRotC(c1, rot);
                        this.nyatla_arGetNewMatrix_row012(rot, trans, combo);
                        double err = 0.0;
                        for (int i = 0; i < num; ++i) {
                            double hx = combo[0] * vertex[i][0] + combo[1] * vertex[i][1] + combo[2] * vertex[i][2] + combo[3];
                            double hy = combo[4] * vertex[i][0] + combo[5] * vertex[i][1] + combo[6] * vertex[i][2] + combo[7];
                            double h = combo[8] * vertex[i][0] + combo[9] * vertex[i][1] + combo[10] * vertex[i][2] + combo[11];
                            double x = hx / h;
                            double y = hy / h;
                            err += (pos2d[i][0] - x) * (pos2d[i][0] - x) + (pos2d[i][1] - y) * (pos2d[i][1] - y);
                        }
                        if (!(err < minerr)) continue;
                        minerr = err;
                        ma = a1;
                        mb = b1;
                        mc = c1;
                        s1 = t1;
                        s2 = t2;
                        s3 = t3;
                    }
                }
            }
            if (s1 == 0 && s2 == 0 && s3 == 0) {
                factor *= 0.5;
            }
            a2 = ma;
            b2 = mb;
            c2 = mc;
        }
        NyARTransRot_O2.arGetRot(ma, mb, mc, this.array);
        return minerr / (double)num;
    }

    private final void nyatla_arGetNewMatrix_row012(double[] i_rot, double[] trans, double[] ret) throws NyARException {
        double[] cpara2 = this.cparam.get34Array();
        for (int j = 0; j < 3; ++j) {
            double c0 = cpara2[j * 4 + 0];
            double c1 = cpara2[j * 4 + 1];
            double c2 = cpara2[j * 4 + 2];
            ret[j * 4 + 0] = c0 * i_rot[0] + c1 * i_rot[3] + c2 * i_rot[6];
            ret[j * 4 + 1] = c0 * i_rot[1] + c1 * i_rot[4] + c2 * i_rot[7];
            ret[j * 4 + 2] = c0 * i_rot[2] + c1 * i_rot[5] + c2 * i_rot[8];
        }
    }

    private final void nyatla_arGetNewMatrix_row3(double[] trans, double[] ret) throws NyARException {
        double[] cpara2 = this.cparam.get34Array();
        for (int j = 0; j < 3; ++j) {
            int j_idx = j * 4;
            ret[j_idx + 3] = cpara2[j_idx + 0] * trans[0] + cpara2[j_idx + 1] * trans[1] + cpara2[j_idx + 2] * trans[2] + cpara2[j_idx + 3];
        }
    }
}

