/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.raster.rgb;

import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_BasicClass;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRgbRaster_BGRA
extends NyARRgbRaster_BasicClass
implements INyARRgbRaster {
    private INyARRgbPixelReader _rgb_reader;
    private INyARBufferReader _buffer_reader;
    private byte[] _ref_buf;

    public static NyARRgbRaster_BGRA wrap(byte[] i_buffer, int i_width, int i_height) {
        return new NyARRgbRaster_BGRA(i_buffer, i_width, i_height);
    }

    private NyARRgbRaster_BGRA(byte[] i_buffer, int i_width, int i_height) {
        super(new NyARIntSize(i_width, i_height));
        this._ref_buf = i_buffer;
        this._rgb_reader = new PixelReader(this);
        this._buffer_reader = new NyARBufferReader(i_buffer, 65793);
    }

    public INyARRgbPixelReader getRgbPixelReader() {
        return this._rgb_reader;
    }

    public INyARBufferReader getBufferReader() {
        return this._buffer_reader;
    }

    private class PixelReader
    implements INyARRgbPixelReader {
        private NyARRgbRaster_BGRA _parent;

        public PixelReader(NyARRgbRaster_BGRA i_parent) {
            this._parent = i_parent;
        }

        public void getPixel(int i_x, int i_y, int[] o_rgb) {
            byte[] ref_buf = this._parent._ref_buf;
            int bp = (i_x + i_y * ((NyARRgbRaster_BGRA)this._parent)._size.w) * 4;
            o_rgb[0] = ref_buf[bp + 2] & 0xFF;
            o_rgb[1] = ref_buf[bp + 1] & 0xFF;
            o_rgb[2] = ref_buf[bp + 0] & 0xFF;
        }

        public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
            int width = ((NyARRgbRaster_BGRA)this._parent)._size.w;
            byte[] ref_buf = this._parent._ref_buf;
            int i = i_num - 1;
            while (i >= 0) {
                int bp = (i_x[i] + i_y[i] * width) * 4;
                o_rgb[i * 3 + 0] = ref_buf[bp + 2] & 0xFF;
                o_rgb[i * 3 + 1] = ref_buf[bp + 1] & 0xFF;
                o_rgb[i * 3 + 2] = ref_buf[bp + 0] & 0xFF;
                --i;
            }
        }
    }
}

