/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.INyARSquareDetector;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARSquareDetector;
import jp.nyatla.nyartoolkit.core.NyARSquareStack;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pickup.NyARColorPatt_O3;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_RgbToBin;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARCustomSingleDetectMarker {
    private static final int AR_SQUARE_MAX = 100;
    private boolean _is_continue = false;
    private NyARMatchPatt_Color_WITHOUT_PCA _match_patt;
    private INyARSquareDetector _square_detect;
    private final NyARSquareStack _square_list = new NyARSquareStack(100);
    private NyARCode _code;
    protected INyARTransMat _transmat;
    private double _marker_width;
    private int _detected_direction;
    private double _detected_confidence;
    private NyARSquare _detected_square;
    private INyARColorPatt _patt;
    private NyARBinRaster _bin_raster;
    protected INyARRasterFilter_RgbToBin _tobin_filter;

    public NyARCustomSingleDetectMarker(NyARParam i_param, NyARCode i_code, double i_marker_width, INyARRasterFilter_RgbToBin i_filter) throws NyARException {
        NyARIntSize scr_size = i_param.getScreenSize();
        this._square_detect = new NyARSquareDetector(i_param.getDistortionFactor(), scr_size);
        this._transmat = new NyARTransMat(i_param);
        this._code = i_code;
        this._marker_width = i_marker_width;
        this._patt = new NyARColorPatt_O3(this._code.getWidth(), this._code.getHeight());
        this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA();
        this._bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
        this._tobin_filter = i_filter;
    }

    public boolean detectMarkerLite(INyARRgbRaster i_raster) throws NyARException {
        if (!this._bin_raster.getSize().isEqualSize(i_raster.getSize())) {
            throw new NyARException();
        }
        this._tobin_filter.doFilter(i_raster, this._bin_raster);
        this._detected_square = null;
        NyARSquareStack l_square_list = this._square_list;
        this._square_detect.detectMarker(this._bin_raster, l_square_list);
        int number_of_square = l_square_list.getLength();
        if (number_of_square < 1) {
            return false;
        }
        if (!this._patt.pickFromRaster(i_raster, (NyARSquare)l_square_list.getItem(0))) {
            return false;
        }
        if (!this._match_patt.setPatt(this._patt)) {
            throw new NyARException();
        }
        this._match_patt.evaluate(this._code);
        int square_index = 0;
        int direction = this._match_patt.getDirection();
        double confidence = this._match_patt.getConfidence();
        int i = 1;
        while (i < number_of_square) {
            this._patt.pickFromRaster(i_raster, (NyARSquare)l_square_list.getItem(i));
            this._match_patt.setPatt(this._patt);
            this._match_patt.evaluate(this._code);
            double c2 = this._match_patt.getConfidence();
            if (!(confidence > c2)) {
                square_index = i;
                direction = this._match_patt.getDirection();
                confidence = c2;
            }
            ++i;
        }
        this._detected_square = (NyARSquare)l_square_list.getItem(square_index);
        this._detected_direction = direction;
        this._detected_confidence = confidence;
        return true;
    }

    public void getTransmationMatrix(NyARTransMatResult o_result) throws NyARException {
        if (this._is_continue) {
            this._transmat.transMatContinue(this._detected_square, this._detected_direction, this._marker_width, o_result);
        } else {
            this._transmat.transMat(this._detected_square, this._detected_direction, this._marker_width, o_result);
        }
    }

    public void getSquarePosition(NyARIntPoint[] o_point) {
        NyARIntPoint.copyArray(this._detected_square.imvertex, o_point);
    }

    public NyARIntPoint[] refSquarePosition() {
        return this._detected_square.imvertex;
    }

    public double getConfidence() {
        return this._detected_confidence;
    }

    public int getDirection() {
        return this._detected_direction;
    }

    public void setContinueMode(boolean i_is_continue) {
        this._is_continue = i_is_continue;
    }
}

