/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterdriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARHistogramFromRaster_INTGS8
implements INyARHistogramFromRaster {
    private INyARRaster _gsr;

    public NyARHistogramFromRaster_INTGS8(INyARRaster i_raster) {
        this._gsr = i_raster;
    }

    @Override
    public void createHistogram(int i_skip, NyARHistogram o_histogram) throws NyARException {
        NyARIntSize s = this._gsr.getSize();
        this.createHistogram(0, 0, s.w, s.h, i_skip, o_histogram);
    }

    @Override
    public void createHistogram(int i_l, int i_t, int i_w, int i_h, int i_skip, NyARHistogram o_histogram) {
        o_histogram.reset();
        int[] input = (int[])this._gsr.getBuffer();
        NyARIntSize s = this._gsr.getSize();
        int skip = i_skip * s.w - i_w;
        int pix_count = i_w;
        int pix_mod_part = pix_count - pix_count % 8;
        int pt = i_t * s.w + i_l;
        int[] data = o_histogram.data;
        int y = i_h - 1;
        while (y >= 0) {
            int x = pix_count - 1;
            while (x >= pix_mod_part) {
                int n = input[pt++];
                data[n] = data[n] + 1;
                --x;
            }
            while (x >= 0) {
                int n = input[pt++];
                data[n] = data[n] + 1;
                int n2 = input[pt++];
                data[n2] = data[n2] + 1;
                int n3 = input[pt++];
                data[n3] = data[n3] + 1;
                int n4 = input[pt++];
                data[n4] = data[n4] + 1;
                int n5 = input[pt++];
                data[n5] = data[n5] + 1;
                int n6 = input[pt++];
                data[n6] = data[n6] + 1;
                int n7 = input[pt++];
                data[n7] = data[n7] + 1;
                int n8 = input[pt++];
                data[n8] = data[n8] + 1;
                x -= 8;
            }
            pt += skip;
            y -= i_skip;
        }
        o_histogram.total_of_data = i_w * i_h / i_skip;
    }
}

