/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.utils;

import jp.nyatla.nyartoolkit.core.NyARException;

public class NyAREquationSolver {
    public static int solve2Equation(double i_a, double i_b, double i_c, double[] o_result) {
        assert (i_a != 0.0);
        return NyAREquationSolver.solve2Equation(i_b / i_a, i_c / i_a, o_result, 0);
    }

    public static int solve2Equation(double i_b, double i_c, double[] o_result) {
        return NyAREquationSolver.solve2Equation(i_b, i_c, o_result, 0);
    }

    public static int solve2Equation(double i_b, double i_c, double[] o_result, int i_result_st) {
        double t = i_b * i_b - 4.0 * i_c;
        if (t < 0.0) {
            return 0;
        }
        if (t == 0.0) {
            o_result[i_result_st + 0] = -i_b / 2.0;
            return 1;
        }
        t = Math.sqrt(t);
        o_result[i_result_st + 0] = (-i_b + t) / 2.0;
        o_result[i_result_st + 1] = (-i_b - t) / 2.0;
        return 2;
    }

    public static int solve3Equation(double i_a, double i_b, double i_c, double i_d, double[] o_result) {
        assert (i_a != 0.0);
        return NyAREquationSolver.solve3Equation(i_b / i_a, i_c / i_a, i_d / i_a, o_result);
    }

    public static int solve3Equation(double i_b, double i_c, double i_d, double[] o_result) {
        double b = i_b / 3.0;
        double q = (b * (i_c - 2.0 * b * b) - i_d) / 2.0;
        double p = b * b - i_c / 3.0;
        double tmp = q * q - p * p * p;
        if (tmp == 0.0) {
            q = Math.cbrt(q);
            o_result[0] = 2.0 * q - b;
            o_result[1] = -q - b;
            return 2;
        }
        if (tmp > 0.0) {
            double a3 = Math.cbrt(q + (double)(q > 0.0 ? 1 : -1) * Math.sqrt(tmp));
            double b3 = p / a3;
            o_result[0] = a3 + b3 - b;
            return 1;
        }
        tmp = 2.0 * Math.sqrt(p);
        double t = Math.acos(q / (p * tmp / 2.0));
        o_result[0] = tmp * Math.cos(t / 3.0) - b;
        o_result[1] = tmp * Math.cos((t + Math.PI * 2) / 3.0) - b;
        o_result[2] = tmp * Math.cos((t + Math.PI * 4) / 3.0) - b;
        return 3;
    }

    public static int solve4Equation(double i_a, double i_b, double i_c, double i_d, double i_e, double[] o_result) throws NyARException {
        assert (i_a != 0.0);
        double A3 = i_b / i_a;
        double A2 = i_c / i_a;
        double A1 = i_d / i_a;
        double A0 = i_e / i_a;
        double B3 = A3 / 4.0;
        double B3_2 = B3 * B3;
        double p = A2 - 6.0 * B3_2;
        double q = A1 + B3 * (-2.0 * A2 + 8.0 * B3_2);
        double r = A0 + B3 * (-A1 + A2 * B3) - 3.0 * B3_2 * B3_2;
        if (q == 0.0) {
            int res = NyAREquationSolver.solve2Equation(p, r, o_result, 0);
            switch (res) {
                case 0: {
                    return 0;
                }
                case 1: {
                    double result_0 = o_result[0];
                    if (result_0 < 0.0) {
                        return 0;
                    }
                    if (result_0 == 0.0) {
                        o_result[0] = 0.0 - B3;
                        return 1;
                    }
                    result_0 = Math.sqrt(result_0);
                    o_result[0] = result_0 - B3;
                    o_result[1] = -result_0 - B3;
                    return 2;
                }
                case 2: {
                    double result_0 = o_result[0];
                    double result_1 = o_result[1];
                    int number_of_result = 0;
                    if (result_0 > 0.0) {
                        result_0 = Math.sqrt(result_0);
                        o_result[0] = result_0 - B3;
                        o_result[1] = -result_0 - B3;
                        number_of_result += 2;
                    }
                    if (result_1 > 0.0) {
                        result_1 = Math.sqrt(result_1);
                        o_result[number_of_result + 0] = result_1 - B3;
                        o_result[number_of_result + 1] = -result_1 - B3;
                        number_of_result += 2;
                    }
                    return number_of_result;
                }
            }
            throw new NyARException();
        }
        double u = NyAREquationSolver.solve3Equation_1(2.0 * p, -4.0 * r + p * p, -q * q);
        if (u < 0.0) {
            return 0;
        }
        double ru = Math.sqrt(u);
        int result_1st = NyAREquationSolver.solve2Equation(-ru, (p + u) / 2.0 + ru * q / (2.0 * u), o_result, 0);
        switch (result_1st) {
            case 0: {
                break;
            }
            case 1: {
                o_result[0] = o_result[0] - B3;
                break;
            }
            case 2: {
                o_result[0] = o_result[0] - B3;
                o_result[1] = o_result[1] - B3;
                break;
            }
            default: {
                throw new NyARException();
            }
        }
        int result_2nd = NyAREquationSolver.solve2Equation(ru, (p + u) / 2.0 - ru * q / (2.0 * u), o_result, result_1st);
        switch (result_2nd) {
            case 0: {
                break;
            }
            case 1: {
                o_result[result_1st + 0] = o_result[result_1st + 0] - B3;
                break;
            }
            case 2: {
                o_result[result_1st + 0] = o_result[result_1st + 0] - B3;
                o_result[result_1st + 1] = o_result[result_1st + 1] - B3;
                break;
            }
            default: {
                throw new NyARException();
            }
        }
        return result_1st + result_2nd;
    }

    private static double solve3Equation_1(double i_b, double i_c, double i_d) {
        double b = i_b / 3.0;
        double q = (b * (i_c - 2.0 * b * b) - i_d) / 2.0;
        double p = b * b - i_c / 3.0;
        double tmp = q * q - p * p * p;
        if (tmp == 0.0) {
            q = Math.cbrt(q);
            return 2.0 * q - b;
        }
        if (tmp > 0.0) {
            double a3 = Math.cbrt(q + (double)(q > 0.0 ? 1 : -1) * Math.sqrt(tmp));
            double b3 = p / a3;
            return a3 + b3 - b;
        }
        tmp = 2.0 * Math.sqrt(p);
        double t = Math.acos(q / (p * tmp / 2.0));
        return tmp * Math.cos(t / 3.0) - b;
    }
}

