/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.utils;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.rpf.utils.VecLinearCoordinates;

public class LineBaseVertexDetector {
    private static final int[][] _45vertextable;
    private static final int[][] _order_table;
    private NyARDoublePoint2d[] __wk_v = NyARDoublePoint2d.createArray(6);

    static {
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = new int[]{1, 2, 4, 3};
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 5;
        nArray[3] = 3;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 5;
        nArray2[3] = 4;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 5;
        nArray3[3] = 4;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 2;
        nArray4[2] = 5;
        nArray4[3] = 3;
        nArrayArray[4] = nArray4;
        nArrayArray[5] = new int[]{1, 2, 4, 3};
        _45vertextable = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[2] = 5;
        nArray5[3] = 4;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[1] = 2;
        nArray6[2] = 5;
        nArray6[3] = 3;
        nArrayArray2[1] = nArray6;
        nArrayArray2[2] = new int[]{1, 2, 4, 3};
        _order_table = nArrayArray2;
    }

    public boolean line2SquareVertex(VecLinearCoordinates.VecLinearCoordinatePoint[] i_line, NyARDoublePoint2d[] o_point) throws NyARException {
        int[] target_order;
        NyARDoublePoint2d[] v = this.__wk_v;
        int number_of_vertex = 0;
        int non_vertexid = 0;
        int ptr = 0;
        int i = 0;
        while (i < 3) {
            int i2 = i + 1;
            while (i2 < 4) {
                if (i_line[i].crossPos(i_line[i2], v[ptr])) {
                    ++number_of_vertex;
                } else {
                    non_vertexid = ptr;
                }
                ++ptr;
                ++i2;
            }
            ++i;
        }
        int num_of_plus = -1;
        switch (number_of_vertex) {
            case 4: 
            case 5: {
                num_of_plus = LineBaseVertexDetector.countPlusExteriorProduct(v, _45vertextable[non_vertexid]);
                target_order = _45vertextable[non_vertexid];
                break;
            }
            case 6: {
                int order_id = -1;
                num_of_plus = -1;
                int i2 = 0;
                while (i2 < 3) {
                    num_of_plus = LineBaseVertexDetector.countPlusExteriorProduct(v, _order_table[i2]);
                    if (num_of_plus % 4 == 0) {
                        order_id = i2;
                        break;
                    }
                    ++i2;
                }
                if (order_id == -1) {
                    return false;
                }
                target_order = _order_table[order_id];
                break;
            }
            default: {
                return false;
            }
        }
        switch (num_of_plus) {
            case 0: {
                int i3 = 0;
                while (i3 < 4) {
                    o_point[i3].setValue(v[target_order[3 - i3]]);
                    ++i3;
                }
                break;
            }
            case 4: {
                int i3 = 0;
                while (i3 < 4) {
                    o_point[i3].setValue(v[target_order[i3]]);
                    ++i3;
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final int countPlusExteriorProduct(NyARDoublePoint2d[] p, int[] order) {
        int ret = 0;
        int i = 0;
        while (i < 4) {
            if (0.0 < NyARDoublePoint2d.crossProduct3Point(p[order[i + 0]], p[order[(i + 1) % 4]], p[order[(i + 2) % 4]])) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }
}

