/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.vfw;

import com.sun.media.JMFSecurityManager;
import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.vfw.VFWSourceStream;
import java.io.IOException;
import javax.media.CaptureDeviceInfo;
import javax.media.Control;
import javax.media.Duration;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;
import javax.media.protocol.SourceStream;

public class DataSource
extends BasicPushBufferDataSource
implements CaptureDevice,
RateConfigureable {
    private PushBufferStream[] streams = null;
    private VFWSourceStream vfwStream = null;
    private static String ContentType = "raw";
    private FormatControl fc = null;
    protected Control[] controls = null;

    public DataSource() {
        JMFSecurityManager.checkCapture();
        this.contentType = ContentType;
        this.duration = Duration.DURATION_UNBOUNDED;
    }

    public void setLocator(MediaLocator loc) {
        super.setLocator(loc);
        if (this.vfwStream == null) {
            this.vfwStream = new VFWSourceStream(this.getLocator());
        }
    }

    public PushBufferStream[] getStreams() {
        if (this.streams == null) {
            System.err.println("DataSource needs to be connected before calling getStreams");
        }
        return this.streams;
    }

    public FormatControl[] getFormatControls() {
        if (this.vfwStream == null) {
            return new FormatControl[0];
        }
        return new FormatControl[]{this.vfwStream};
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        if (this.vfwStream == null) {
            return null;
        }
        return this.vfwStream.getCaptureDeviceInfo();
    }

    public void connect() throws IOException {
        if (this.streams == null) {
            this.streams = new PushBufferStream[1];
            if (this.vfwStream == null) {
                this.vfwStream = new VFWSourceStream(this.getLocator());
            }
            this.streams[0] = this.vfwStream;
        }
        this.vfwStream.connect(null);
        super.connect();
    }

    public void disconnect() {
        this.vfwStream.disconnect();
        super.disconnect();
    }

    public void start() throws IOException {
        this.vfwStream.start();
        super.start();
    }

    public void stop() throws IOException {
        this.vfwStream.stop();
        super.stop();
    }

    boolean getStarted() {
        return this.started;
    }

    public Object[] getControls() {
        if (this.vfwStream != null) {
            return this.vfwStream.getControls();
        }
        return new Control[0];
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            int i2 = 0;
            while (i2 < cs.length) {
                if (cls.isInstance(cs[i2])) {
                    return cs[i2];
                }
                ++i2;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public RateConfiguration[] getRateConfigurations() {
        RateConfiguration[] config = new RateConfiguration[]{new OneRateConfig()};
        return config;
    }

    public RateConfiguration setRateConfiguration(RateConfiguration config) {
        return config;
    }

    class OneRateConfig
    implements RateConfiguration {
        OneRateConfig() {
        }

        public RateRange getRate() {
            return new RateRange(1.0f, 1.0f, 1.0f, true);
        }

        public SourceStream[] getStreams() {
            SourceStream[] ss = new SourceStream[]{DataSource.this.vfwStream};
            return ss;
        }
    }
}

