/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCS is C++ version NyARToolkit class library.
* 
* Copyright (C)2008 R.Iizuka
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this framework; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp>
* 
*/
#pragma once
#include "NyARBaseClass.h"

namespace NyARToolkitCPP
{
	class INyARBufferReader:public NyARBaseClass
	{
	public:
		const static int BYTE1D =0x00010000;
		const static int INT2D  =0x00020000;
		const static int SHORT1D=0x00030000;
		const static int INT1D  =0x00040000;
		//  IDK
		//  24-31(8)\
		//  16-27(8)^ID
		//      00:/01:byte[]/02:int[][]/03:short[]
		//  08-15(8)rbgtH[}bgID
		//      00:24bit/01:32bit/02:16bit
		//  00-07(8)^ԍ
		//
		/**
		* RGB24tH[}bgŁASẲf0
		*/
		const static int BUFFERFORMAT_NULL_ALLZERO = 0x00000001;

		/**
		* byte[]ŁAR8G8B824rbgŉfi[ĂB
		*/
		const static int BUFFERFORMAT_BYTE1D_R8G8B8_24   = BYTE1D|0x0001;
		/**
		* byte[]ŁAB8G8R824rbgŉfi[ĂB
		*/
		const static int BUFFERFORMAT_BYTE1D_B8G8R8_24   = BYTE1D|0x0002;
		/**
		* byte[]ŁAR8G8B8X832rbgŉfi[ĂB
		*/
		const static int BUFFERFORMAT_BYTE1D_B8G8R8X8_32 = BYTE1D|0x0101;
		const static int BUFFERFORMAT_BYTE1D_X8R8G8B8_32 = BYTE1D|0x0102;

		/**
		* byte[]ŁARGB56516rbg(little/big endian)ŉfi[ĂB
		*/
		const static int BUFFERFORMAT_BYTE1D_R5G6B5_16LE = BYTE1D|0x0201;
		const static int BUFFERFORMAT_BYTE1D_R5G6B5_16BE = BYTE1D|0x0202;
		/**
		* short[]ŁARGB56516rbg(little/big endian)ŉfi[ĂB
		*/	
		const static int BUFFERFORMAT_WORD1D_R5G6B5_16LE = SHORT1D|0x0201;
		const static int BUFFERFORMAT_WORD1D_R5G6B5_16BE = SHORT1D|0x0202;


		/**
		* int[][]œɒl͈͂߂Ȃ
		*/
		const static int BUFFERFORMAT_INT2D        = INT2D|0x0000;
		/**
		* int[][]0-255̃OCXP[摜
		*/
		const static int BUFFERFORMAT_INT2D_GRAY_8 = INT2D|0x0001;
		/**
		* int[][]0/12l摜
		*/
		const static int BUFFERFORMAT_INT2D_BIN_8  = INT2D|0x0002;

		/**
		* int[]œɒl͈͂߂Ȃ
		*/
		const static int BUFFERFORMAT_INT1D        = INT1D|0x0000;
		/**
		* int[]0-255̃OCXP[摜
		*/
		const static int BUFFERFORMAT_INT1D_GRAY_8 = INT1D|0x0001;
		/**
		* int[]0/12l摜
		*/
		const static int BUFFERFORMAT_INT1D_BIN_8  = INT1D|0x0002;
		/**
		* int[]ŁAXRGB3232rbgŉfi[ĂB
		*/	
		const static int BUFFERFORMAT_INT1D_X8R8G8B8_32 = INT1D|0x0102;

		virtual const void* getBuffer() const=0;
		virtual int getBufferType() const=0;
		virtual bool isEqualBufferType(int i_type_value) const=0;
	};
}
