/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/

#pragma once
#include "NyARRgbPixelReader_RGB24.h"
#include "NyAR_types.h"
#include "INyARRgbPixelReader.h"
#include "NyARBufferReader.h"
#include "NyARRgbRaster_BasicClass.h"

namespace NyARToolkitCPP
{
	class NyARRgbRaster_RGB:public NyARRgbRaster_BasicClass
	{
	private:
		INyARRgbPixelReader* _rgb_reader;
		NyARBufferReader* _buffer_reader;
		const NyAR_BYTE_t* _ref_buf;
	public:
		//i_bufferbv郉X^B
		NyARRgbRaster_RGB(const NyAR_BYTE_t* i_ref_buffer, int i_width, int i_height);
	private:
		virtual ~NyARRgbRaster_RGB();
	public:
		const INyARRgbPixelReader& getRgbPixelReader()const;
		const INyARBufferReader& getBufferReader()const;
	};
}
