/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#pragma once
#include "NyARCoord2Linear.h"
#include "NyARSquareContourDetector.h"
#include "NyARMatchPattDeviationColorData.h"
#include "NyARTransMat.h"
#include "NyARRectOffset.h"
#include "NyARRasterFilter_ARToolkitThreshold.h"
#include "NyARRasterThresholdAnalyzer_SlidePTile.h"
#include "NyARCode.h"
namespace NyARToolkitCPP
{
	class DetectSquareCB;
	/**
	* ̃NX́AɂP̃}[J邱Ƃ̂łAAvP[VvZbTłB
	* }[J̏oEړEłACxgŒʒm邱Ƃł܂B
	* NXɂ͕̃}[Jo^ł܂B̃}[JƁAvZbT͌pē}[J
	* PFA܂ł̊Ԃ͑̃}[JF܂B
	* 
	* CxǵA OnEnterOnUpdate[n]OnLeavȅŔ܂B
	* }[JƂ܂OnEnterPxāAԂ̃}[Jꂽ킩܂B
	* OnUpdateɂA݂̕ϊs񂪘Aēn܂BŌɃ}[JƁAOnLeave
	* Cxg܂B
	* 
	*/
	class SingleARMarkerProcesser:public NyARBaseClass
	{
	public:
		/**I[i[RɎg^OϐłB
		*/
		void* tag;
	private:
		int _lost_delay_count;
		int _lost_delay;
		NyARSquareContourDetector* _square_detect;
	protected:
		NyARTransMat* _transmat;
	private:
		NyARRectOffset _offset; 
		int _threshold;
		NyARBinRaster* _bin_raster;
		NyARRasterFilter_ARToolkitThreshold* _tobin_filter;
	protected:
		int _current_arcode_index;
	private:
		NyARRasterThresholdAnalyzer_SlidePTile* _threshold_detect;
	private:
		bool _initialized;
		DetectSquareCB* _detectmarker_cb;
	protected:
		SingleARMarkerProcesser();
		~SingleARMarkerProcesser();
		virtual void initInstance(const NyARParam* i_param,int i_raster_type);
	public:
		/**o}[JR[h̔zw肵܂B oԂł̊֐sƁA
		 * IuWFNgԂɋZbg܂B
		 */
		void setARCodeTable(NyARCode* const i_ref_code_table[],int i_number_of_code, int i_code_resolution, double i_marker_width);
		void reset(bool i_is_force);
		void detectMarker(const INyARRgbRaster& i_raster);
		void setConfidenceThreshold(double i_new_cf,double i_exist_cf);
	private:
		NyARTransMatResult __NyARSquare_result;
	/**	IuWFNg̃Xe[^XXVAKvɉănh֐쓮܂B
	 * 	߂ĺAuۂɃ}[J𔭌鎖łvłBNX̏ԂƂ͈قȂ܂B
	 */
	private:
		bool updateStatus(const NyARSquare& i_square, int i_code_index);
	protected:
		virtual void onEnterHandler(int i_code)=0;
		virtual void onLeaveHandler()=0;
		virtual void onUpdateHandler(const NyARSquare& i_square, const NyARTransMatResult& result)=0;
	};
}
