/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public class NyARFrustum {
    protected NyARDoubleMatrix44 _frustum_rh = new NyARDoubleMatrix44();
    protected NyARDoubleMatrix44 _inv_frustum_rh = new NyARDoubleMatrix44();
    protected NyARIntSize _screen_size = new NyARIntSize();

    public NyARFrustum() {
    }

    public NyARFrustum(NyARPerspectiveProjectionMatrix i_perspective_mat, int i_width, int i_height, double i_near, double i_far) {
        this.setValue(i_perspective_mat, i_width, i_height, i_near, i_far);
    }

    public void setValue(NyARDoubleMatrix44 i_projection_mat, int i_width, int i_height) {
        this._frustum_rh.setValue(i_projection_mat);
        this._inv_frustum_rh.inverse(this._frustum_rh);
        this._screen_size.setValue(i_width, i_height);
    }

    public void setValue(NyARPerspectiveProjectionMatrix i_artk_perspective_mat, int i_width, int i_height, double i_near, double i_far) {
        i_artk_perspective_mat.makeCameraFrustumRH(i_width, i_height, i_near, i_far, this._frustum_rh);
        this._inv_frustum_rh.inverse(this._frustum_rh);
        this._screen_size.setValue(i_width, i_height);
    }

    public final void unProject(double ix, double iy, NyARDoublePoint3d o_point_on_screen) {
        double n = this._frustum_rh.m23 / (this._frustum_rh.m22 - 1.0);
        NyARDoubleMatrix44 m44 = this._inv_frustum_rh;
        double v1 = ((double)this._screen_size.w - ix - 1.0) * 2.0 / (double)this._screen_size.w - 1.0;
        double v2 = ((double)this._screen_size.h - iy - 1.0) * 2.0 / (double)this._screen_size.h - 1.0;
        double v3 = 2.0 * n - 1.0;
        double b = 1.0 / (m44.m30 * v1 + m44.m31 * v2 + m44.m32 * v3 + m44.m33);
        o_point_on_screen.x = (m44.m00 * v1 + m44.m01 * v2 + m44.m02 * v3 + m44.m03) * b;
        o_point_on_screen.y = (m44.m10 * v1 + m44.m11 * v2 + m44.m12 * v3 + m44.m13) * b;
        o_point_on_screen.z = (m44.m20 * v1 + m44.m21 * v2 + m44.m22 * v3 + m44.m23) * b;
    }

    public final void unProjectOnCamera(double ix, double iy, NyARDoubleMatrix44 i_mat, NyARDoublePoint3d o_pos) {
        this.unProject(ix, iy, o_pos);
        double nx = i_mat.m02;
        double ny = i_mat.m12;
        double nz = i_mat.m22;
        double mx = i_mat.m03;
        double my = i_mat.m13;
        double mz = i_mat.m23;
        double t = (nx * mx + ny * my + nz * mz) / (nx * o_pos.x + ny * o_pos.y + nz * o_pos.z);
        o_pos.x = t * o_pos.x;
        o_pos.y = t * o_pos.y;
        o_pos.z = t * o_pos.z;
    }

    public final boolean unProjectOnMatrix(double ix, double iy, NyARDoubleMatrix44 i_mat, NyARDoublePoint3d o_pos) {
        this.unProjectOnCamera(ix, iy, i_mat, o_pos);
        NyARDoubleMatrix44 m = new NyARDoubleMatrix44();
        if (!m.inverse(i_mat)) {
            return false;
        }
        m.transform3d(o_pos, o_pos);
        return true;
    }

    public final void project(double i_x, double i_y, double i_z, NyARDoublePoint2d o_pos2d) {
        NyARDoubleMatrix44 m = this._frustum_rh;
        double v3_1 = 1.0 / i_z * m.m32;
        double w = this._screen_size.w;
        double h = this._screen_size.h;
        o_pos2d.x = w - (1.0 + (i_x * m.m00 + i_z * m.m02) * v3_1) * w / 2.0;
        o_pos2d.y = h - (1.0 + (i_y * m.m11 + i_z * m.m12) * v3_1) * h / 2.0;
    }

    public final void project(NyARDoublePoint3d i_pos, NyARDoublePoint2d o_pos2d) {
        this.project(i_pos.x, i_pos.y, i_pos.z, o_pos2d);
    }

    public final NyARDoubleMatrix44 getMatrix() {
        return this._frustum_rh;
    }

    public final NyARDoubleMatrix44 getInvMatrix() {
        return this._inv_frustum_rh;
    }

    public FrustumParam getFrustumParam(FrustumParam o_value) {
        double near;
        NyARDoubleMatrix44 mat = this._frustum_rh;
        o_value.far = mat.m23 / (mat.m22 + 1.0);
        o_value.near = near = mat.m23 / (mat.m22 - 1.0);
        o_value.left = (mat.m02 - 1.0) * near / mat.m00;
        o_value.right = (mat.m02 + 1.0) * near / mat.m00;
        o_value.bottom = (mat.m12 - 1.0) * near / mat.m11;
        o_value.top = (mat.m12 + 1.0) * near / mat.m11;
        return o_value;
    }

    public PerspectiveParam getPerspectiveParam(PerspectiveParam o_value) {
        NyARDoubleMatrix44 mat = this._frustum_rh;
        o_value.far = mat.m23 / (mat.m22 + 1.0);
        o_value.near = mat.m23 / (mat.m22 - 1.0);
        o_value.aspect = mat.m11 / mat.m00;
        o_value.fovy = 2.0 * Math.atan(1.0 / (mat.m00 * o_value.aspect));
        return o_value;
    }

    public static class FrustumParam {
        public double far;
        public double near;
        public double left;
        public double right;
        public double bottom;
        public double top;
    }

    public static class PerspectiveParam {
        public double far;
        public double near;
        public double aspect;
        public double fovy;
    }
}

