/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.gs;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.INyARGsCustomToneTableFilter;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.INyARGsEqualizeHistFilter;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.NyARGsFilterFactory;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;

class NyARGsEqualizeHistFilter_Any
implements INyARGsEqualizeHistFilter {
    private INyARGsCustomToneTableFilter _tone_table;
    private INyARHistogramFromRaster _histdrv;
    private NyARHistogram _histogram = new NyARHistogram(256);
    private int[] _hist = new int[256];

    public NyARGsEqualizeHistFilter_Any(INyARGrayscaleRaster i_raster) throws NyARException {
        this._tone_table = NyARGsFilterFactory.createCustomToneTableFilter(i_raster);
        this._histdrv = (INyARHistogramFromRaster)i_raster.createInterface(INyARHistogramFromRaster.class);
    }

    @Override
    public void doFilter(int i_hist_interval, INyARGrayscaleRaster i_output) throws NyARException {
        NyARHistogram hist = this._histogram;
        this._histdrv.createHistogram(i_hist_interval, hist);
        int hist_total = this._histogram.total_of_data;
        int min = hist.getMinData();
        int hist_size = this._histogram.length;
        int sum = 0;
        int i = 0;
        while (i < hist_size) {
            this._hist[i] = ((sum += hist.data[i]) - min) * (hist_size - 1) / (hist_total - min);
            ++i;
        }
        this._tone_table.doFilter(this._hist, i_output);
    }
}

