/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup_BIN_GS8;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup_GsReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARContourPickup {
    private INyARRaster _ref_last_input_raster = null;
    private IRasterDriver _imdriver;

    public boolean getContour(INyARGrayscaleRaster i_raster, int i_th, int i_entry_x, int i_entry_y, NyARIntCoordinates o_coord) throws NyARException {
        NyARIntSize s = i_raster.getSize();
        if (i_raster != this._ref_last_input_raster) {
            this._imdriver = (IRasterDriver)i_raster.createInterface(IRasterDriver.class);
            this._ref_last_input_raster = i_raster;
        }
        return this._imdriver.getContour(0, 0, s.w - 1, s.h - 1, i_entry_x, i_entry_y, i_th, o_coord);
    }

    public boolean getContour(INyARGrayscaleRaster i_raster, NyARIntRect i_area, int i_th, int i_entry_x, int i_entry_y, NyARIntCoordinates o_coord) throws NyARException {
        if (i_raster != this._ref_last_input_raster) {
            this._imdriver = (IRasterDriver)i_raster.createInterface(IRasterDriver.class);
            this._ref_last_input_raster = i_raster;
        }
        return this._imdriver.getContour(i_area.x, i_area.y, i_area.x + i_area.w - 1, i_area.h + i_area.y - 1, i_entry_x, i_entry_y, i_th, o_coord);
    }

    public static interface IRasterDriver {
        public boolean getContour(int var1, int var2, int var3, int var4, int var5, int var6, int var7, NyARIntCoordinates var8) throws NyARException;
    }

    public static class ImageDriverFactory {
        public static IRasterDriver createDriver(INyARGrayscaleRaster i_ref_raster) throws NyARException {
            switch (i_ref_raster.getBufferType()) {
                case 262145: 
                case 262146: {
                    return new NyARContourPickup_BIN_GS8(i_ref_raster);
                }
            }
            if (i_ref_raster instanceof NyARContourPickup_GsReader) {
                return new NyARContourPickup_GsReader(i_ref_raster);
            }
            throw new NyARException();
        }
    }
}

