/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;

public class NyARIntSize {
    public int h;
    public int w;

    public NyARIntSize() {
        this.w = 0;
        this.h = 0;
    }

    public NyARIntSize(NyARIntSize i_ref_object) {
        this.w = i_ref_object.w;
        this.h = i_ref_object.h;
    }

    public NyARIntSize(int i_width, int i_height) {
        this.w = i_width;
        this.h = i_height;
    }

    public final void setValue(int i_w, int i_h) {
        this.w = i_w;
        this.h = i_h;
    }

    public final boolean isEqualSize(int i_width, int i_height) {
        return i_width == this.w && i_height == this.h;
    }

    public final boolean isEqualSize(NyARIntSize i_size) {
        return i_size.w == this.w && i_size.h == this.h;
    }

    public final boolean isInnerSize(int i_x, int i_y) {
        return i_x <= this.w && i_y <= this.h;
    }

    public final boolean isInnerSize(NyARIntSize i_size) {
        return i_size.w <= this.w && i_size.h <= this.h;
    }

    public final boolean isInnerPoint(int i_x, int i_y) {
        return i_x < this.w && i_y < this.h && i_x >= 0 && i_y >= 0;
    }

    public final boolean isInnerPoint(NyARDoublePoint2d i_pos) {
        return i_pos.x < (double)this.w && i_pos.y < (double)this.h && 0.0 <= i_pos.x && 0.0 <= i_pos.y;
    }

    public final boolean isInnerPoint(NyARIntPoint2d i_pos) {
        return i_pos.x < this.w && i_pos.y < this.h && i_pos.x >= 0 && i_pos.y >= 0;
    }

    public final void setAreaRect(NyARDoublePoint2d[] i_vertex, int i_num_of_vertex) {
        int ymax;
        int xmax;
        int xmin = xmax = (int)i_vertex[i_num_of_vertex - 1].x;
        int ymin = ymax = (int)i_vertex[i_num_of_vertex - 1].y;
        int i = i_num_of_vertex - 2;
        while (i >= 0) {
            if (i_vertex[i].x < (double)xmin) {
                xmin = (int)i_vertex[i].x;
            } else if (i_vertex[i].x > (double)xmax) {
                xmax = (int)i_vertex[i].x;
            }
            if (i_vertex[i].y < (double)ymin) {
                ymin = (int)i_vertex[i].y;
            } else if (i_vertex[i].y > (double)ymax) {
                ymax = (int)i_vertex[i].y;
            }
            --i;
        }
        this.h = ymax - ymin + 1;
        this.w = xmax - xmin + 1;
    }

    public final void setAreaRect(NyARIntPoint2d[] i_vertex, int i_num_of_vertex) {
        int ymax;
        int xmax;
        int xmin = xmax = i_vertex[i_num_of_vertex - 1].x;
        int ymin = ymax = i_vertex[i_num_of_vertex - 1].y;
        int i = i_num_of_vertex - 2;
        while (i >= 0) {
            if (i_vertex[i].x < xmin) {
                xmin = i_vertex[i].x;
            } else if (i_vertex[i].x > xmax) {
                xmax = i_vertex[i].x;
            }
            if (i_vertex[i].y < ymin) {
                ymin = i_vertex[i].y;
            } else if (i_vertex[i].y > ymax) {
                ymax = i_vertex[i].y;
            }
            --i;
        }
        this.h = ymax - ymin + 1;
        this.w = xmax - xmin + 1;
    }
}

