/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem.utils;

import java.util.ArrayList;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.markersystem.utils.SquareStack;
import jp.nyatla.nyartoolkit.markersystem.utils.TMarkerData;
import jp.nyatla.nyartoolkit.psarplaycard.PsARPlayCardPickup;

public class ARPlayCardList
extends ArrayList<Item> {
    private static final long serialVersionUID = -6446466460932931830L;
    private PsARPlayCardPickup _pickup;
    private final PsARPlayCardPickup.PsArIdParam _id_param = new PsARPlayCardPickup.PsArIdParam();

    public ARPlayCardList() throws NyARException {
        this._pickup = new PsARPlayCardPickup();
    }

    public void prepare() {
    }

    public boolean update(INyARGrayscaleRaster i_raster, SquareStack.Item i_sq) throws NyARException {
        if (!this._pickup.getARPlayCardId(i_raster.getGsPixelDriver(), i_sq.ob_vertex, this._id_param)) {
            return false;
        }
        int s = this._id_param.id;
        int i = this.size() - 1;
        while (i >= 0) {
            Item target = (Item)this.get(i);
            if (target.nyid_range_s <= s && s <= target.nyid_range_e && target.lost_count != 0) {
                target.id = s;
                target.dir = this._id_param.direction;
                target.sq = i_sq;
                return true;
            }
            --i;
        }
        return false;
    }

    public void finish() {
        int i = this.size() - 1;
        while (i >= 0) {
            Item target = (Item)this.get(i);
            if (target.sq != null && target.lost_count > 0) {
                target.lost_count = 0;
                target.life = target.life + 1L;
                target.sq.rotateVertexL(4 - target.dir);
                NyARIntPoint2d.shiftCopy(target.sq.ob_vertex, target.tl_vertex, 4 - target.dir);
                target.tl_center.setValue(target.sq.center2d);
                target.tl_rect_area = target.sq.rect_area;
            }
            --i;
        }
    }

    public static class Item
    extends TMarkerData {
        public final int nyid_range_s;
        public final int nyid_range_e;
        public long id;
        public int dir;

        public Item(int i_id_range_s, int i_id_range_e, double i_patt_size) {
            this.marker_offset.setSquare(i_patt_size);
            this.nyid_range_s = i_id_range_s;
            this.nyid_range_e = i_id_range_e;
        }
    }
}

