/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.processor;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.analyzer.histogram.NyARHistogramAnalyzer_SlidePTile;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilter;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_Rle;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResultParam;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerParam;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPickup;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerDataEncoder;

public abstract class SingleNyIdMarkerProcesser {
    public Object tag;
    private int _lost_delay_count = 0;
    private int _lost_delay = 5;
    private RleDetector _square_detect;
    protected INyARTransMat _transmat;
    private NyARRectOffset _offset;
    private boolean _is_active;
    private int _current_threshold = 110;
    private NyARGrayscaleRaster _gs_raster;
    private INyIdMarkerData _data_current;
    private NyARHistogramAnalyzer_SlidePTile _threshold_detect;
    private NyARHistogram _hist = new NyARHistogram(256);
    private INyARHistogramFromRaster _histmaker;
    private boolean _initialized = false;
    private INyARRgbRaster _last_input_raster;
    private INyARRgb2GsFilter _togs_filter;
    private NyARDoubleMatrix44 _transmat_result = new NyARDoubleMatrix44();
    private NyARTransMatResultParam _last_result_param = new NyARTransMatResultParam();

    protected SingleNyIdMarkerProcesser() {
    }

    protected void initInstance(NyARParam i_param, INyIdMarkerDataEncoder i_encoder, double i_marker_width) throws NyARException {
        assert (!this._initialized);
        NyARIntSize scr_size = i_param.getScreenSize();
        this._square_detect = new RleDetector(i_param, i_encoder, new NyIdMarkerPickup());
        this._transmat = new NyARTransMat(i_param);
        this._gs_raster = new NyARGrayscaleRaster(scr_size.w, scr_size.h);
        this._histmaker = (INyARHistogramFromRaster)this._gs_raster.createInterface(INyARHistogramFromRaster.class);
        this._data_current = i_encoder.createDataInstance();
        this._threshold_detect = new NyARHistogramAnalyzer_SlidePTile(15);
        this._initialized = true;
        this._is_active = false;
        this._offset = new NyARRectOffset();
        this._offset.setSquare(i_marker_width);
    }

    public void setMarkerWidth(int i_width) {
        this._offset.setSquare(i_width);
    }

    public void reset(boolean i_is_force) {
        if (!i_is_force && this._is_active) {
            this.onLeaveHandler();
        }
        this._is_active = false;
    }

    public void detectMarker(INyARRgbRaster i_raster) throws NyARException {
        if (!this._gs_raster.getSize().isEqualSize(i_raster.getSize().w, i_raster.getSize().h)) {
            throw new NyARException();
        }
        if (this._last_input_raster != i_raster) {
            this._togs_filter = (INyARRgb2GsFilter)i_raster.createInterface(INyARRgb2GsFilter.class);
            this._last_input_raster = i_raster;
        }
        this._togs_filter.convert(this._gs_raster);
        this._square_detect.init(this._gs_raster, this._is_active ? this._data_current : null);
        this._square_detect.detectMarker(this._gs_raster, this._current_threshold, this._square_detect);
        boolean is_id_found = this.updateStatus(this._square_detect.square, this._square_detect.marker_data);
        if (is_id_found) {
            this._current_threshold = (this._current_threshold + this._square_detect.threshold) / 2;
        } else {
            this._histmaker.createHistogram(4, this._hist);
            int th = this._threshold_detect.getThreshold(this._hist);
            this._current_threshold = (this._current_threshold + th) / 2;
        }
    }

    private boolean updateStatus(NyARSquare i_square, INyIdMarkerData i_marker_data) throws NyARException {
        boolean is_id_found = false;
        if (!this._is_active) {
            if (i_marker_data == null) {
                this._is_active = false;
            } else {
                this._data_current.copyFrom(i_marker_data);
                this.onEnterHandler(this._data_current);
                this._transmat.transMat(i_square, this._offset, this._transmat_result, this._last_result_param);
                this.onUpdateHandler(i_square, this._transmat_result);
                this._lost_delay_count = 0;
                this._is_active = true;
                is_id_found = true;
            }
        } else if (i_marker_data == null) {
            ++this._lost_delay_count;
            if (this._lost_delay < this._lost_delay_count) {
                this.onLeaveHandler();
                this._is_active = false;
            }
        } else if (this._data_current.isEqual(i_marker_data)) {
            if (!this._transmat.transMatContinue(i_square, this._offset, this._transmat_result, this._last_result_param.last_error, this._transmat_result, this._last_result_param)) {
                this._transmat.transMat(i_square, this._offset, this._transmat_result, this._last_result_param);
            }
            this.onUpdateHandler(i_square, this._transmat_result);
            this._lost_delay_count = 0;
            is_id_found = true;
        } else {
            throw new NyARException();
        }
        return is_id_found;
    }

    protected abstract void onEnterHandler(INyIdMarkerData var1);

    protected abstract void onLeaveHandler();

    protected abstract void onUpdateHandler(NyARSquare var1, NyARDoubleMatrix44 var2);

    private class RleDetector
    extends NyARSquareContourDetector_Rle
    implements NyARSquareContourDetector.CbHandler {
        public final NyARSquare square;
        public INyIdMarkerData marker_data;
        public int threshold;
        private INyARGrayscaleRaster _ref_raster;
        private INyIdMarkerData _current_data;
        private final NyIdMarkerPickup _id_pickup;
        private NyARCoord2Linear _coordline;
        private INyIdMarkerDataEncoder _encoder;
        private INyIdMarkerData _data_temp;
        private INyIdMarkerData _prev_data;
        private NyARIntPoint2d[] __ref_vertex;
        private final NyIdMarkerParam _marker_param;
        private final NyIdMarkerPattern _marker_data;

        public RleDetector(NyARParam i_param, INyIdMarkerDataEncoder i_encoder, NyIdMarkerPickup i_id_pickup) throws NyARException {
            super(i_param.getScreenSize());
            this.square = new NyARSquare();
            this.__ref_vertex = new NyARIntPoint2d[4];
            this._marker_param = new NyIdMarkerParam();
            this._marker_data = new NyIdMarkerPattern();
            this._coordline = new NyARCoord2Linear(i_param.getScreenSize(), i_param.getDistortionFactor());
            this._data_temp = i_encoder.createDataInstance();
            this._current_data = i_encoder.createDataInstance();
            this._encoder = i_encoder;
            this._id_pickup = i_id_pickup;
        }

        public void init(INyARGrayscaleRaster i_raster, INyIdMarkerData i_prev_data) {
            this.marker_data = null;
            this._prev_data = i_prev_data;
            this._ref_raster = i_raster;
        }

        @Override
        public void detectMarkerCallback(NyARIntCoordinates i_coord, int[] i_vertex_index) throws NyARException {
            if (this.marker_data != null) {
                return;
            }
            NyARIntPoint2d[] vertex = this.__ref_vertex;
            vertex[0] = i_coord.items[i_vertex_index[0]];
            vertex[1] = i_coord.items[i_vertex_index[1]];
            vertex[2] = i_coord.items[i_vertex_index[2]];
            vertex[3] = i_coord.items[i_vertex_index[3]];
            NyIdMarkerParam param = this._marker_param;
            NyIdMarkerPattern patt_data = this._marker_data;
            if (!this._id_pickup.pickFromRaster(this._ref_raster.getGsPixelDriver(), vertex, patt_data, param)) {
                return;
            }
            if (!this._encoder.encode(patt_data, this._data_temp)) {
                return;
            }
            if (this._prev_data == null) {
                this._current_data.copyFrom(this._data_temp);
            } else if (!this._prev_data.isEqual(this._data_temp)) {
                return;
            }
            NyARSquare sq = this.square;
            int i = 0;
            while (i < 4) {
                int idx = (i + 4 - param.direction) % 4;
                this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coord, sq.line[i]);
                ++i;
            }
            i = 0;
            while (i < 4) {
                if (!sq.line[i].crossPos(sq.line[(i + 3) % 4], sq.sqvertex[i])) {
                    throw new NyARException();
                }
                ++i;
            }
            this.threshold = param.threshold;
            this.marker_data = this._current_data;
        }
    }
}

