/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;

public class NyARColorPatt_O1
implements INyARColorPatt {
    private static final int AR_PATT_SAMPLE_NUM = 64;
    private int[][][] extpat;
    private int width;
    private int height;
    private final NyARMat wk_get_cpara_a = new NyARMat(8, 8);
    private final NyARMat wk_get_cpara_b = new NyARMat(8, 1);
    private final NyARMat wk_get_cpara_c = new NyARMat(8, 1);
    private final double[][] wk_pickFromRaster_local = new double[4][2];
    private final double[] wk_pickFromRaster_para = new double[9];
    private int[][][] wk_pickFromRaster_ext_pat2 = null;
    private final double[][] wk_pickFromRaster_world = new double[][]{{100.0, 100.0}, {110.0, 100.0}, {110.0, 110.0}, {100.0, 110.0}};
    private final int[] wk_pickFromRaster_rgb_tmp = new int[3];

    public NyARColorPatt_O1(int i_width, int i_height) {
        this.width = i_width;
        this.height = i_height;
        this.extpat = new int[i_height][i_width][3];
        this.wk_pickFromRaster_ext_pat2 = new int[i_height][i_width][3];
    }

    public int[][][] getPatArray() {
        return this.extpat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean get_cpara(double[][] world, double[][] vertex, double[] para) throws NyARException {
        NyARMat a = this.wk_get_cpara_a;
        double[][] a_array = a.getArray();
        NyARMat b = this.wk_get_cpara_b;
        double[][] b_array = b.getArray();
        int i = 0;
        while (i < 4) {
            double[] a_pt0 = a_array[i * 2];
            double[] a_pt1 = a_array[i * 2 + 1];
            double[] world_pti = world[i];
            a_pt0[0] = world_pti[0];
            a_pt0[1] = world_pti[1];
            a_pt0[2] = 1.0;
            a_pt0[3] = 0.0;
            a_pt0[4] = 0.0;
            a_pt0[5] = 0.0;
            a_pt0[6] = -world_pti[0] * vertex[i][0];
            a_pt0[7] = -world_pti[1] * vertex[i][0];
            a_pt1[0] = 0.0;
            a_pt1[1] = 0.0;
            a_pt1[2] = 0.0;
            a_pt1[3] = world_pti[0];
            a_pt1[4] = world_pti[1];
            a_pt1[5] = 1.0;
            a_pt1[6] = -world_pti[0] * vertex[i][1];
            a_pt1[7] = -world_pti[1] * vertex[i][1];
            b_array[i * 2 + 0][0] = vertex[i][0];
            b_array[i * 2 + 1][0] = vertex[i][1];
            ++i;
        }
        if (!a.matrixSelfInv()) {
            return false;
        }
        NyARMat c = this.wk_get_cpara_c;
        double[][] c_array = c.getArray();
        c.matrixMul(a, b);
        int i2 = 0;
        while (i2 < 2) {
            para[i2 * 3 + 0] = c_array[i2 * 3 + 0][0];
            para[i2 * 3 + 1] = c_array[i2 * 3 + 1][0];
            para[i2 * 3 + 2] = c_array[i2 * 3 + 2][0];
            ++i2;
        }
        para[6] = c_array[6][0];
        para[7] = c_array[7][0];
        para[8] = 1.0;
        return true;
    }

    private static void initValue_wk_pickFromRaster_ext_pat2(int[][][] i_ext_pat2, int i_width, int i_height) {
        int i = i_height - 1;
        while (i >= 0) {
            int[][] pt2 = i_ext_pat2[i];
            int i2 = i_width - 1;
            while (i2 >= 0) {
                int[] pt1 = pt2[i2];
                pt1[0] = 0;
                pt1[1] = 0;
                pt1[2] = 0;
                --i2;
            }
            --i;
        }
    }

    public boolean pickFromRaster(INyARRgbRaster image, NyARSquare i_square) throws NyARException {
        int[] ext_pat2_j_i;
        int i;
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        double[][] local = this.wk_pickFromRaster_local;
        int i2 = 0;
        while (i2 < 4) {
            local[i2][0] = i_square.imvertex[i2].x;
            local[i2][1] = i_square.imvertex[i2].y;
            ++i2;
        }
        double[][] world = this.wk_pickFromRaster_world;
        double[] para = this.wk_pickFromRaster_para;
        if (!this.get_cpara(world, local, para)) {
            return false;
        }
        int lx1 = (int)((local[0][0] - local[1][0]) * (local[0][0] - local[1][0]) + (local[0][1] - local[1][1]) * (local[0][1] - local[1][1]));
        int lx2 = (int)((local[2][0] - local[3][0]) * (local[2][0] - local[3][0]) + (local[2][1] - local[3][1]) * (local[2][1] - local[3][1]));
        int ly1 = (int)((local[1][0] - local[2][0]) * (local[1][0] - local[2][0]) + (local[1][1] - local[2][1]) * (local[1][1] - local[2][1]));
        int ly2 = (int)((local[3][0] - local[0][0]) * (local[3][0] - local[0][0]) + (local[3][1] - local[0][1]) * (local[3][1] - local[0][1]));
        if (lx2 > lx1) {
            lx1 = lx2;
        }
        if (ly2 > ly1) {
            ly1 = ly2;
        }
        int xdiv2 = this.width;
        int ydiv2 = this.height;
        while (xdiv2 * xdiv2 < lx1 / 4) {
            xdiv2 *= 2;
        }
        while (ydiv2 * ydiv2 < ly1 / 4) {
            ydiv2 *= 2;
        }
        if (xdiv2 > 64) {
            xdiv2 = 64;
        }
        if (ydiv2 > 64) {
            ydiv2 = 64;
        }
        int xdiv = xdiv2 / this.width;
        int ydiv = ydiv2 / this.height;
        int[][][] ext_pat2 = this.wk_pickFromRaster_ext_pat2;
        NyARColorPatt_O1.initValue_wk_pickFromRaster_ext_pat2(ext_pat2, this.width, this.height);
        double xdiv2_reciprocal = 1.0 / (double)xdiv2;
        double ydiv2_reciprocal = 1.0 / (double)ydiv2;
        int[] rgb_tmp = this.wk_pickFromRaster_rgb_tmp;
        INyARRgbPixelReader reader = image.getRgbPixelReader();
        int j = 0;
        while (j < ydiv2) {
            double yw = 102.5 + 5.0 * ((double)j + 0.5) * ydiv2_reciprocal;
            i = 0;
            while (i < xdiv2) {
                double xw = 102.5 + 5.0 * ((double)i + 0.5) * xdiv2_reciprocal;
                double d = para[6] * xw + para[7] * yw + para[8];
                if (d == 0.0) {
                    throw new NyARException();
                }
                int xc = (int)((para[0] * xw + para[1] * yw + para[2]) / d);
                int yc = (int)((para[3] * xw + para[4] * yw + para[5]) / d);
                if (xc >= 0 && xc < img_x && yc >= 0 && yc < img_y) {
                    reader.getPixel(xc, yc, rgb_tmp);
                    ext_pat2_j_i = ext_pat2[j / ydiv][i / xdiv];
                    ext_pat2_j_i[0] = ext_pat2_j_i[0] + rgb_tmp[0];
                    ext_pat2_j_i[1] = ext_pat2_j_i[1] + rgb_tmp[1];
                    ext_pat2_j_i[2] = ext_pat2_j_i[2] + rgb_tmp[2];
                }
                ++i;
            }
            ++j;
        }
        int xdiv_x_ydiv = xdiv * ydiv;
        j = this.height - 1;
        while (j >= 0) {
            int[][] extpat_j = this.extpat[j];
            int[][] ext_pat2_j = ext_pat2[j];
            i = this.width - 1;
            while (i >= 0) {
                ext_pat2_j_i = ext_pat2_j[i];
                int[] extpat_j_i = extpat_j[i];
                extpat_j_i[0] = ext_pat2_j_i[0] / xdiv_x_ydiv;
                extpat_j_i[1] = ext_pat2_j_i[1] / xdiv_x_ydiv;
                extpat_j_i[2] = ext_pat2_j_i[2] / xdiv_x_ydiv;
                --i;
            }
            --j;
        }
        return true;
    }
}

