/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;

class NyARCodeFileReader {
    NyARCodeFileReader() {
    }

    public static void loadFromARToolKitFormFile(InputStream i_stream, NyARRaster[] o_raster) throws NyARException {
        assert (o_raster.length == 4);
        try {
            StreamTokenizer st = new StreamTokenizer(new InputStreamReader(i_stream));
            int h = 0;
            while (h < 4) {
                assert (o_raster[h].isEqualBufferType(262402));
                NyARRaster ra = o_raster[h];
                NyARCodeFileReader.readBlock(st, ra.getWidth(), ra.getHeight(), (int[])ra.getBuffer());
                ++h;
            }
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    public static void loadFromARToolKitFormFile(InputStream i_stream, NyARCode o_code) throws NyARException {
        int width = o_code.getWidth();
        int height = o_code.getHeight();
        NyARRgbRaster tmp_raster = new NyARRgbRaster(width, height, 262402);
        try {
            StreamTokenizer st = new StreamTokenizer(new InputStreamReader(i_stream));
            int[] buf = (int[])tmp_raster.getBuffer();
            int h = 0;
            while (h < 4) {
                NyARCodeFileReader.readBlock(st, width, height, buf);
                o_code.getColorData(h).setRaster(tmp_raster);
                o_code.getBlackWhiteData(h).setRaster(tmp_raster);
                ++h;
            }
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
        tmp_raster = null;
    }

    private static void readBlock(StreamTokenizer i_st, int i_width, int i_height, int[] o_buf) throws NyARException {
        try {
            int pixels = i_width * i_height;
            int i3 = 0;
            while (i3 < 3) {
                int i2 = 0;
                while (i2 < pixels) {
                    switch (i_st.nextToken()) {
                        case -2: {
                            break;
                        }
                        default: {
                            throw new NyARException();
                        }
                    }
                    o_buf[i2] = o_buf[i2] << 8 | 0xFF & (int)i_st.nval;
                    ++i2;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < pixels) {
                o_buf[i3] = o_buf[i3] << 16 & 0xFF0000 | o_buf[i3] & 0xFF00 | o_buf[i3] >> 16 & 0xFF;
                ++i3;
            }
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }
}

