/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.jmf.utils;

import java.awt.Dimension;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.jmf.utils.JmfCaptureListener;
import jp.nyatla.nyartoolkit.jmf.utils.MonitorCDS;
import jp.nyatla.nyartoolkit.jmf.utils.MonitorStream;

public class JmfCameraCapture {
    private Dimension image_size;
    private JmfCaptureListener capture_listener;
    private DataSource jmf_data_source;
    private MonitorStream jmf_monitor_stream;
    private Processor jmf_processor;
    private VideoFormat jmf_video_format;
    private Buffer read_buf = new Buffer();
    public static final String PIXEL_FORMAT_RGB = "RGB";

    public JmfCameraCapture(int i_width, int i_height, float i_rate, String i_pixcel_format) {
        String encoding = i_pixcel_format;
        this.image_size = new Dimension(i_width, i_height);
        this.jmf_video_format = new VideoFormat(encoding, this.image_size, -1, null, i_rate);
    }

    public Dimension getSize() {
        return this.image_size;
    }

    public Buffer readBuffer() throws NyARException {
        if (this.jmf_monitor_stream == null) {
            throw new NyARException();
        }
        try {
            this.jmf_monitor_stream.read(this.read_buf);
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
        return this.read_buf;
    }

    public void setCaptureListener(JmfCaptureListener i_listener) throws NyARException {
        if (this.jmf_processor != null) {
            throw new NyARException();
        }
        this.capture_listener = i_listener;
    }

    public void start() throws NyARException {
        Processor processor;
        DataSource ds = JmfCameraCapture.getCaptureDS(this.jmf_video_format);
        VideoFormat[] formats = new VideoFormat[]{new VideoFormat(null)};
        ProcessorModel pm = new ProcessorModel(ds, (Format[])formats, null);
        try {
            processor = Manager.createRealizedProcessor((ProcessorModel)pm);
        }
        catch (Exception e) {
            ds.disconnect();
            throw new NyARException(e);
        }
        this.jmf_monitor_stream = (MonitorStream)ds.getControl("jmfsample.MonitorStream");
        this.jmf_monitor_stream.setCaptureListener(this.capture_listener);
        this.jmf_data_source = ds;
        this.jmf_processor = processor;
        this.jmf_processor.start();
    }

    public void stop() {
        this.jmf_processor.stop();
        this.jmf_processor.close();
        this.jmf_processor = null;
    }

    protected void finalize() {
        if (this.jmf_processor != null) {
            this.jmf_processor.stop();
            this.jmf_processor.close();
            this.jmf_processor = null;
        }
    }

    private static DataSource getCaptureDS(VideoFormat vf) {
        Object dsVideo = null;
        DataSource ds = null;
        if (vf != null && (dsVideo = JmfCameraCapture.createDataSource((Format)vf)) == null) {
            return null;
        }
        if (dsVideo != null) {
            dsVideo = new MonitorCDS((DataSource)dsVideo);
            return dsVideo;
        }
        try {
            ds = Manager.createMergingDataSource((DataSource[])new DataSource[]{dsVideo});
        }
        catch (IncompatibleSourceException ise) {
            return null;
        }
        return ds;
    }

    private static DataSource createDataSource(Format format) {
        DataSource ds;
        Vector devices = CaptureDeviceManager.getDeviceList((Format)format);
        if (devices.size() < 1) {
            System.err.println("! No Devices for " + format);
            return null;
        }
        CaptureDeviceInfo cdi = (CaptureDeviceInfo)devices.elementAt(0);
        MediaLocator ml = cdi.getLocator();
        try {
            ds = Manager.createDataSource((MediaLocator)ml);
            ds.connect();
            if (ds instanceof CaptureDevice) {
                JmfCameraCapture.setCaptureFormat((CaptureDevice)ds, format);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
        return ds;
    }

    private static void setCaptureFormat(CaptureDevice cdev, Format format) {
        FormatControl[] fcs = cdev.getFormatControls();
        if (fcs.length < 1) {
            return;
        }
        FormatControl fc = fcs[0];
        Format[] formats = fc.getSupportedFormats();
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].matches(format)) continue;
            format = formats[i].intersects(format);
            fc.setFormat(format);
            break;
        }
    }
}

