/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.util;

public class DoublePointer {
    private double[] array_ref;
    private int array_offset;
    private int position;

    public static DoublePointer wrap(double[] i_array_ref, int i_offset) {
        return new DoublePointer(i_array_ref, i_offset);
    }

    public static DoublePointer wrap(DoublePointer i_inst) {
        return new DoublePointer(i_inst.array_ref, i_inst.getPtrArrayOffset());
    }

    public DoublePointer slice(int i_offset) {
        return DoublePointer.wrap(this.array_ref, this.array_offset + this.position + i_offset);
    }

    public void set(double i_value) {
        this.array_ref[this.array_offset + this.position] = i_value;
    }

    public void set(int i_rel_positon, double i_value) {
        this.array_ref[this.array_offset + this.position + i_rel_positon] = i_value;
    }

    public double get() {
        return this.array_ref[this.array_offset + this.position];
    }

    public double get(int i_slide) {
        return this.array_ref[this.array_offset + this.position + i_slide];
    }

    public void incPtr() {
        ++this.position;
    }

    public void addPtr(int v) {
        this.position += v;
    }

    public double[] array() {
        return this.array_ref;
    }

    public void subValue(double i_val) {
        int n = this.array_offset + this.position;
        this.array_ref[n] = this.array_ref[n] - i_val;
    }

    public void subValue(int i_step, double i_val) {
        int n = this.array_offset + this.position + i_step;
        this.array_ref[n] = this.array_ref[n] - i_val;
    }

    public void addValue(double i_val) {
        int n = this.array_offset + this.position;
        this.array_ref[n] = this.array_ref[n] + i_val;
    }

    public void addValue(int i_step, double i_val) {
        int n = this.array_offset + this.position + i_step;
        this.array_ref[n] = this.array_ref[n] + i_val;
    }

    public int getPtrArrayOffset() {
        return this.array_offset + this.position;
    }

    private DoublePointer(double[] i_array_ref, int i_base_point) {
        this.array_offset = i_base_point;
        this.array_ref = i_array_ref;
        this.position = 0;
    }

    public DoublePointer(int i_length) {
        this.array_offset = 0;
        this.array_ref = new double[i_length];
        this.position = 0;
    }

    public DoublePointer() {
        this.array_offset = 0;
        this.array_ref = new double[1];
        this.position = 0;
    }
}

