/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransOffset;
import jp.nyatla.nyartoolkit.core.transmat.fitveccalc.NyARFitVecCalculator;
import jp.nyatla.nyartoolkit.core.transmat.optimize.INyARRotTransOptimize;
import jp.nyatla.nyartoolkit.core.transmat.optimize.NyARRotTransOptimize_O2;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix_NyARToolKit;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;

public class NyARTransMat
implements INyARTransMat {
    private static final double AR_GET_TRANS_CONT_MAT_MAX_FIT_ERROR = 1.0;
    private final NyARDoublePoint2d _center = new NyARDoublePoint2d(0.0, 0.0);
    private final NyARTransOffset _offset = new NyARTransOffset();
    protected NyARRotMatrix _rotmatrix;
    protected NyARFitVecCalculator _calculator;
    protected INyARRotTransOptimize _mat_optimize;
    private final NyARDoublePoint2d[] __transMat_sqvertex_ref = new NyARDoublePoint2d[4];
    private final NyARLinear[] __transMat_linear_ref = new NyARLinear[4];
    private final NyARDoublePoint3d __transMat_trans = new NyARDoublePoint3d();

    protected NyARTransMat() {
    }

    public NyARTransMat(NyARParam i_param) throws NyARException {
        NyARCameraDistortionFactor dist = i_param.getDistortionFactor();
        NyARPerspectiveProjectionMatrix pmat = i_param.getPerspectiveProjectionMatrix();
        this._calculator = new NyARFitVecCalculator(pmat, dist);
        this._rotmatrix = new NyARRotMatrix_NyARToolKit(pmat);
        this._mat_optimize = new NyARRotTransOptimize_O2(pmat);
    }

    public void setCenter(double i_x, double i_y) {
        this._center.x = i_x;
        this._center.y = i_y;
    }

    private final void initVertexOrder(NyARSquare i_square, int i_direction, NyARDoublePoint2d[] o_sqvertex_ref, NyARLinear[] o_liner_ref) {
        o_sqvertex_ref[0] = i_square.sqvertex[(4 - i_direction) % 4];
        o_sqvertex_ref[1] = i_square.sqvertex[(5 - i_direction) % 4];
        o_sqvertex_ref[2] = i_square.sqvertex[(6 - i_direction) % 4];
        o_sqvertex_ref[3] = i_square.sqvertex[(7 - i_direction) % 4];
        o_liner_ref[0] = i_square.line[(4 - i_direction) % 4];
        o_liner_ref[1] = i_square.line[(5 - i_direction) % 4];
        o_liner_ref[2] = i_square.line[(6 - i_direction) % 4];
        o_liner_ref[3] = i_square.line[(7 - i_direction) % 4];
    }

    public void transMat(NyARSquare i_square, int i_direction, double i_width, NyARTransMatResult o_result_conv) throws NyARException {
        NyARDoublePoint2d[] sqvertex_ref = this.__transMat_sqvertex_ref;
        NyARLinear[] linear_ref = this.__transMat_linear_ref;
        NyARDoublePoint3d trans = this.__transMat_trans;
        this.initVertexOrder(i_square, i_direction, sqvertex_ref, linear_ref);
        this._offset.setSquare(i_width, this._center);
        this._rotmatrix.initRotBySquare(linear_ref, sqvertex_ref);
        this._calculator.setOffsetSquare(this._offset);
        this._calculator.setFittedSquare(sqvertex_ref);
        this._calculator.calculateTransfer(this._rotmatrix, trans);
        this._mat_optimize.optimize(this._rotmatrix, trans, this._calculator);
        this.updateMatrixValue(this._rotmatrix, this._offset.point, trans, o_result_conv);
    }

    public void transMatContinue(NyARSquare i_square, int i_direction, double i_width, NyARTransMatResult io_result_conv) throws NyARException {
        NyARDoublePoint2d[] sqvertex_ref = this.__transMat_sqvertex_ref;
        NyARLinear[] linear_ref = this.__transMat_linear_ref;
        NyARDoublePoint3d trans = this.__transMat_trans;
        if (!io_result_conv.has_value) {
            this.transMat(i_square, i_direction, i_width, io_result_conv);
            return;
        }
        this._offset.setSquare(i_width, this._center);
        this._rotmatrix.initRotByPrevResult(io_result_conv);
        this._calculator.setOffsetSquare(this._offset);
        this._calculator.setFittedSquare(sqvertex_ref);
        this._calculator.calculateTransfer(this._rotmatrix, trans);
        double err = this._mat_optimize.optimize(this._rotmatrix, trans, this._calculator);
        this.updateMatrixValue(this._rotmatrix, this._offset.point, trans, io_result_conv);
        if (err > 1.0) {
            this._rotmatrix.initRotBySquare(linear_ref, sqvertex_ref);
            this._calculator.calculateTransfer(this._rotmatrix, trans);
            double err2 = this._mat_optimize.optimize(this._rotmatrix, trans, this._calculator);
            if (err2 < err) {
                this.updateMatrixValue(this._rotmatrix, this._offset.point, trans, io_result_conv);
            }
        }
    }

    public void updateMatrixValue(NyARRotMatrix i_rot, NyARDoublePoint3d i_off, NyARDoublePoint3d i_trans, NyARTransMatResult o_result) {
        o_result.m00 = i_rot.m00;
        o_result.m01 = i_rot.m01;
        o_result.m02 = i_rot.m02;
        o_result.m03 = i_rot.m00 * i_off.x + i_rot.m01 * i_off.y + i_rot.m02 * i_off.z + i_trans.x;
        o_result.m10 = i_rot.m10;
        o_result.m11 = i_rot.m11;
        o_result.m12 = i_rot.m12;
        o_result.m13 = i_rot.m10 * i_off.x + i_rot.m11 * i_off.y + i_rot.m12 * i_off.z + i_trans.y;
        o_result.m20 = i_rot.m20;
        o_result.m21 = i_rot.m21;
        o_result.m22 = i_rot.m22;
        o_result.m23 = i_rot.m20 * i_off.x + i_rot.m21 * i_off.y + i_rot.m22 * i_off.z + i_trans.z;
        o_result.angle.copyFrom(i_rot.refAngle());
        o_result.has_value = true;
    }
}

