/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARLabel;
import jp.nyatla.nyartoolkit.core.NyARLabeling;
import jp.nyatla.nyartoolkit.core.NyARMarker;
import jp.nyatla.nyartoolkit.core.NyARMarkerList;

public class NyARDetectMarker {
    private static final int AR_AREA_MAX = 100000;
    private static final int AR_AREA_MIN = 70;
    private int width;
    private int height;
    private static final int AR_CHAIN_MAX = 10000;
    private final int[] wk_arGetContour_xdir = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private final int[] wk_arGetContour_ydir = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
    private final int[] wk_arGetContour_xcoord = new int[10000];
    private final int[] wk_arGetContour_ycoord = new int[10000];

    public NyARDetectMarker(int i_width, int i_height) {
        this.width = i_width;
        this.height = i_height;
    }

    private final void arGetContour(NyARMarker o_marker, int[][] limage, int[] label_ref, int i_labelnum, NyARLabel i_label) throws NyARException {
        int coord_num;
        int v1;
        int[] ycoord;
        int[] xcoord;
        block5: {
            int i;
            xcoord = this.wk_arGetContour_xcoord;
            ycoord = this.wk_arGetContour_ycoord;
            int[] xdir = this.wk_arGetContour_xdir;
            int[] ydir = this.wk_arGetContour_ydir;
            int sx = 0;
            int sy = 0;
            v1 = 0;
            int j = i_label.clip2;
            int[] limage_j = limage[j];
            int clip1 = i_label.clip1;
            for (i = i_label.clip0; i <= clip1; ++i) {
                int w = limage_j[i];
                if (w <= 0 || label_ref[w - 1] != i_labelnum) continue;
                sx = i;
                sy = j;
                break;
            }
            if (i > clip1) {
                System.out.println("??? 1");
                throw new NyARException();
            }
            coord_num = 1;
            xcoord[0] = sx;
            ycoord[0] = sy;
            int dir = 5;
            int c = xcoord[0];
            int r = ycoord[0];
            int dmax = 0;
            do {
                dir = (dir + 5) % 8;
                for (i = 0; i < 8 && limage[r + ydir[dir]][c + xdir[dir]] <= 0; ++i) {
                    dir = (dir + 1) % 8;
                }
                if (i == 8) {
                    System.out.println("??? 2");
                    throw new NyARException();
                }
                xcoord[coord_num] = c += xdir[dir];
                ycoord[coord_num] = r += ydir[dir];
                if (c == sx && r == sy) break block5;
                int d = (c - sx) * (c - sx) + (r - sy) * (r - sy);
                if (d <= dmax) continue;
                dmax = d;
                v1 = coord_num;
            } while (++coord_num != 9999);
            System.out.println("??? 3");
            throw new NyARException();
        }
        o_marker.setCoordXY(v1, coord_num, xcoord, ycoord);
    }

    public final void detectMarker(NyARLabeling i_labeling, double i_factor, NyARMarkerList o_marker_list) throws NyARException {
        NyARLabel[] labels = i_labeling.getLabel();
        int label_num = i_labeling.getLabelNum();
        int[][] limage = i_labeling.getLabelImg();
        int[] label_ref = i_labeling.getLabelRef();
        o_marker_list.reset();
        int xsize = this.width;
        int ysize = this.height;
        NyARMarker current_marker = o_marker_list.getCurrentHolder();
        for (int i = 0; i < label_num; ++i) {
            NyARLabel label_pt = labels[i];
            int label_area = label_pt.area;
            if (label_area < 70 || label_area > 100000 || label_pt.clip0 == 1 || label_pt.clip1 == xsize - 2 || label_pt.clip2 == 1 || label_pt.clip3 == ysize - 2) continue;
            this.arGetContour(current_marker, limage, label_ref, i + 1, label_pt);
            if (current_marker.checkSquare(label_area, i_factor, label_pt.pos_x, label_pt.pos_y) && (current_marker = o_marker_list.getNextHolder()) == null) break;
        }
        o_marker_list.updateMarkerArray();
    }
}

