/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import processing.core.PApplet;
import processing.core.PMatrix3D;

class NyARPsgBaseClass {
    public static final int CS_RIGHT = 0;
    public static final int CS_LEFT = 1;
    public final String VERSION = "NyAR4psg/0.3.0;NyARToolkit for java/2.5.0+;ARToolKit/2.72.1";
    public final double[] projection = new double[16];
    protected PMatrix3D _ps_projection = new PMatrix3D();
    protected PApplet _pa;
    protected NyARParam _ar_param;
    private static final double view_distance_min = 100.0;
    private static final double view_distance_max = 100000.0;
    private static double view_scale_factor = 1.0;

    protected NyARPsgBaseClass(PApplet parent, String i_cparam_file, int i_width, int i_htight, int i_projection_coord_system) {
        NyARPsgBaseClass.checkCoordinateSystemRange(parent, i_projection_coord_system);
        this._pa = parent;
        try {
            this._ar_param = new NyARParam();
            this._ar_param.loadARParam(this._pa.createInput(i_cparam_file));
            this._ar_param.changeScreenSize(i_width, i_htight);
            this.initProjection(parent, this._ar_param, i_projection_coord_system);
        }
        catch (NyARException e) {
            this._pa.die("Error while setting up NyARToolkit for java", (Exception)((Object)e));
        }
    }

    private void initProjection(PApplet i_pa, NyARParam i_param, int i_coord_system) {
        int j;
        NyARMat trans_mat = new NyARMat(3, 4);
        NyARMat icpara_mat = new NyARMat(3, 4);
        double[][] p = new double[3][3];
        double[][] q = new double[4][4];
        NyARIntSize size = i_param.getScreenSize();
        int width = size.w;
        int height = size.h;
        i_param.getPerspectiveProjectionMatrix().decompMat(icpara_mat, trans_mat);
        double[][] icpara = icpara_mat.getArray();
        double[][] trans = trans_mat.getArray();
        int i = 0;
        while (i < 4) {
            icpara[1][i] = (double)(height - 1) * icpara[2][i] - icpara[1][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                p[i][j] = icpara[i][j] / icpara[2][2];
                ++j;
            }
            ++i;
        }
        q[0][0] = 2.0 * p[0][0] / (double)(width - 1);
        q[0][1] = 2.0 * p[0][1] / (double)(width - 1);
        q[0][2] = -(2.0 * p[0][2] / (double)(width - 1) - 1.0);
        q[0][3] = 0.0;
        q[1][0] = 0.0;
        q[1][1] = -(2.0 * p[1][1] / (double)(height - 1));
        q[1][2] = -(2.0 * p[1][2] / (double)(height - 1) - 1.0);
        q[1][3] = 0.0;
        q[2][0] = 0.0;
        q[2][1] = 0.0;
        q[2][2] = -1.002002002002002;
        q[2][3] = -200.20020020020021;
        q[3][0] = 0.0;
        q[3][1] = 0.0;
        q[3][2] = -1.0;
        q[3][3] = 0.0;
        switch (i_coord_system) {
            case 1: {
                break;
            }
            case 0: {
                q[2][2] = q[2][2] * -1.0;
                q[2][3] = q[2][3] * -1.0;
                break;
            }
            default: {
                i_pa.die("Please set NyARBoard.CS_LEFT or NyARBoard.CS_RIGHT.");
            }
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 3) {
                this.projection[i + j * 4] = q[i][0] * trans[0][j] + q[i][1] * trans[1][j] + q[i][2] * trans[2][j];
                ++j;
            }
            this.projection[i + 12] = q[i][0] * trans[0][3] + q[i][1] * trans[1][3] + q[i][2] * trans[2][3] + q[i][3];
            ++i;
        }
        this._ps_projection.m00 = (float)this.projection[0];
        this._ps_projection.m01 = (float)this.projection[1];
        this._ps_projection.m02 = (float)this.projection[2];
        this._ps_projection.m03 = (float)this.projection[3];
        this._ps_projection.m10 = (float)this.projection[4];
        this._ps_projection.m11 = (float)this.projection[5];
        this._ps_projection.m12 = (float)this.projection[6];
        this._ps_projection.m13 = (float)this.projection[7];
        this._ps_projection.m20 = (float)this.projection[8];
        this._ps_projection.m21 = (float)this.projection[9];
        this._ps_projection.m22 = (float)this.projection[10];
        this._ps_projection.m23 = (float)this.projection[11];
        this._ps_projection.m30 = (float)this.projection[12];
        this._ps_projection.m31 = (float)this.projection[13];
        this._ps_projection.m32 = (float)this.projection[14];
        this._ps_projection.m33 = (float)this.projection[15];
        this._ps_projection.transpose();
    }

    private static final void checkCoordinateSystemRange(PApplet i_pa, int i_cs) {
        switch (i_cs) {
            case 0: 
            case 1: {
                return;
            }
        }
        i_pa.die("Please set constant CS_LEFT or CS_RIGHT.");
    }

    protected static void matResult2GLArray(NyARTransMatResult i_src, double[] o_gl_array) {
        o_gl_array[0] = i_src.m00;
        o_gl_array[4] = i_src.m01;
        o_gl_array[8] = i_src.m02;
        o_gl_array[12] = i_src.m03;
        o_gl_array[1] = -i_src.m10;
        o_gl_array[5] = -i_src.m11;
        o_gl_array[9] = -i_src.m12;
        o_gl_array[13] = -i_src.m13;
        o_gl_array[2] = -i_src.m20;
        o_gl_array[6] = -i_src.m21;
        o_gl_array[10] = -i_src.m22;
        o_gl_array[14] = -i_src.m23;
        o_gl_array[3] = 0.0;
        o_gl_array[7] = 0.0;
        o_gl_array[11] = 0.0;
        o_gl_array[15] = 1.0;
        if (view_scale_factor != 0.0) {
            o_gl_array[12] = o_gl_array[12] * view_scale_factor;
            o_gl_array[13] = o_gl_array[13] * view_scale_factor;
            o_gl_array[14] = o_gl_array[14] * view_scale_factor;
        }
    }
}

