/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.IPickupRasterImpl;
import jp.nyatla.nyartoolkit.core.rasterreader.PPickup_Impl_AnyRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.PPickup_Impl_BYTE1D_B8G8R8X8_32;
import jp.nyatla.nyartoolkit.core.rasterreader.PPickup_Impl_BYTE1D_B8G8R8_24;
import jp.nyatla.nyartoolkit.core.rasterreader.PPickup_Impl_BYTE1D_R8G8B8_24;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator_O1;

public class NyARPerspectiveRasterReader {
    protected NyARPerspectiveParamGenerator _perspective_gen;
    private static final int LOCAL_LT = 1;
    protected final double[] __pickFromRaster_cpara = new double[8];
    private IPickupRasterImpl _picker;

    private void initializeInstance(int i_buffer_type) {
        switch (i_buffer_type) {
            case 65793: {
                this._picker = new PPickup_Impl_BYTE1D_B8G8R8X8_32();
                break;
            }
            case 65538: {
                this._picker = new PPickup_Impl_BYTE1D_B8G8R8_24();
                break;
            }
            case 65537: {
                this._picker = new PPickup_Impl_BYTE1D_R8G8B8_24();
                break;
            }
            default: {
                this._picker = new PPickup_Impl_AnyRaster();
            }
        }
        this._perspective_gen = new NyARPerspectiveParamGenerator_O1(1, 1);
    }

    public NyARPerspectiveRasterReader() {
        this.initializeInstance(1);
    }

    public NyARPerspectiveRasterReader(int i_input_raster_type) {
        this.initializeInstance(i_input_raster_type);
    }

    public boolean read4Point(INyARRgbRaster i_in_raster, NyARDoublePoint2d[] i_vertex, int i_edge_x, int i_edge_y, int i_resolution, INyARRgbRaster o_out) throws NyARException {
        NyARIntSize out_size = o_out.getSize();
        int xe = out_size.w * i_edge_x / 50;
        int ye = out_size.h * i_edge_y / 50;
        if (i_resolution == 1) {
            if (!this._perspective_gen.getParam(xe * 2 + out_size.w, ye * 2 + out_size.h, i_vertex, this.__pickFromRaster_cpara)) {
                return false;
            }
            this._picker.onePixel(xe + 1, ye + 1, this.__pickFromRaster_cpara, i_in_raster, o_out);
        } else {
            if (!this._perspective_gen.getParam((xe * 2 + out_size.w) * i_resolution, (ye * 2 + out_size.h) * i_resolution, i_vertex, this.__pickFromRaster_cpara)) {
                return false;
            }
            this._picker.multiPixel(xe * i_resolution + 1, ye * i_resolution + 1, this.__pickFromRaster_cpara, i_resolution, i_in_raster, o_out);
        }
        return true;
    }

    public boolean read4Point(INyARRgbRaster i_in_raster, NyARIntPoint2d[] i_vertex, int i_edge_x, int i_edge_y, int i_resolution, INyARRgbRaster o_out) throws NyARException {
        NyARIntSize out_size = o_out.getSize();
        int xe = out_size.w * i_edge_x / 50;
        int ye = out_size.h * i_edge_y / 50;
        if (i_resolution == 1) {
            if (!this._perspective_gen.getParam(xe * 2 + out_size.w, ye * 2 + out_size.h, i_vertex, this.__pickFromRaster_cpara)) {
                return false;
            }
            this._picker.onePixel(xe + 1, ye + 1, this.__pickFromRaster_cpara, i_in_raster, o_out);
        } else {
            if (!this._perspective_gen.getParam((xe * 2 + out_size.w) * i_resolution, (ye * 2 + out_size.h) * i_resolution, i_vertex, this.__pickFromRaster_cpara)) {
                return false;
            }
            this._picker.multiPixel(xe * i_resolution + 1, ye * i_resolution + 1, this.__pickFromRaster_cpara, i_resolution, i_in_raster, o_out);
        }
        return true;
    }

    public boolean read4Point(INyARRgbRaster i_in_raster, double i_x1, double i_y1, double i_x2, double i_y2, double i_x3, double i_y3, double i_x4, double i_y4, int i_edge_x, int i_edge_y, int i_resolution, INyARRgbRaster o_out) throws NyARException {
        NyARIntSize out_size = o_out.getSize();
        int xe = out_size.w * i_edge_x / 50;
        int ye = out_size.h * i_edge_y / 50;
        if (i_resolution == 1) {
            if (!this._perspective_gen.getParam(xe * 2 + out_size.w, ye * 2 + out_size.h, i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, this.__pickFromRaster_cpara)) {
                return false;
            }
            this._picker.onePixel(xe + 1, ye + 1, this.__pickFromRaster_cpara, i_in_raster, o_out);
        } else {
            if (!this._perspective_gen.getParam((xe * 2 + out_size.w) * i_resolution, (ye * 2 + out_size.h) * i_resolution, i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, this.__pickFromRaster_cpara)) {
                return false;
            }
            this._picker.multiPixel(xe * i_resolution + 1, ye * i_resolution + 1, this.__pickFromRaster_cpara, i_resolution, i_in_raster, o_out);
        }
        return true;
    }
}

