/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_Rgb2Bin;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_ARToolkitThreshold
implements INyARRasterFilter_Rgb2Bin {
    protected int _threshold;
    private IdoThFilterImpl _do_threshold_impl;

    public NyARRasterFilter_ARToolkitThreshold(int i_threshold, int i_in_raster_type) throws NyARException {
        if (!this.initInstance(i_threshold, i_in_raster_type, 262146)) {
            throw new NyARException();
        }
    }

    public NyARRasterFilter_ARToolkitThreshold(int i_threshold, int i_in_raster_type, int i_out_raster_type) throws NyARException {
        if (!this.initInstance(i_threshold, i_in_raster_type, i_out_raster_type)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(int i_threshold, int i_in_raster_type, int i_out_raster_type) {
        block0 : switch (i_out_raster_type) {
            case 262146: {
                switch (i_in_raster_type) {
                    case 65537: 
                    case 65538: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_BYTE1D_RGB_24();
                        break block0;
                    }
                    case 65793: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_BYTE1D_B8G8R8X8_32();
                        break block0;
                    }
                    case 65794: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_BYTE1D_X8R8G8B8_32();
                        break block0;
                    }
                    case 262402: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32();
                        break block0;
                    }
                    case 197121: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_WORD1D_R5G6B5_16LE();
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        this._threshold = i_threshold;
        return true;
    }

    public void setThreshold(int i_threshold) {
        this._threshold = i_threshold;
    }

    public void doFilter(INyARRgbRaster i_input, NyARBinRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        this._do_threshold_impl.doThFilter(i_input, i_output, i_output.getSize(), this._threshold);
    }

    static interface IdoThFilterImpl {
        public void doThFilter(INyARRaster var1, INyARRaster var2, NyARIntSize var3, int var4);
    }

    class doThFilterImpl_BUFFERFORMAT_BYTE1D_B8G8R8X8_32
    implements IdoThFilterImpl {
        doThFilterImpl_BUFFERFORMAT_BYTE1D_B8G8R8X8_32() {
        }

        public void doThFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size, int i_threshold) {
            int w;
            assert (i_input.isEqualBufferType(65793));
            assert (i_output.isEqualBufferType(262146));
            int[] out_buf = (int[])i_output.getBuffer();
            byte[] in_buf = (byte[])i_input.getBuffer();
            int th = i_threshold * 3;
            int bp = (i_size.w * i_size.h - 1) * 4;
            int pix_count = i_size.h * i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int xy = pix_count - 1;
            while (xy >= pix_mod_part) {
                w = (in_buf[bp] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[xy] = w <= th ? 0 : 1;
                bp -= 4;
                --xy;
            }
            while (xy >= 0) {
                w = (in_buf[bp] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 4] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 4] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 4] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 4] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 4] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 4] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 4] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                bp -= 4;
                --xy;
            }
        }
    }

    class doThFilterImpl_BUFFERFORMAT_BYTE1D_RGB_24
    implements IdoThFilterImpl {
        doThFilterImpl_BUFFERFORMAT_BYTE1D_RGB_24() {
        }

        public void doThFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size, int i_threshold) {
            int w;
            assert (i_output.isEqualBufferType(262146));
            int[] out_buf = (int[])i_output.getBuffer();
            byte[] in_buf = (byte[])i_input.getBuffer();
            int th = i_threshold * 3;
            int bp = (i_size.w * i_size.h - 1) * 3;
            int pix_count = i_size.h * i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int xy = pix_count - 1;
            while (xy >= pix_mod_part) {
                w = (in_buf[bp] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[xy] = w <= th ? 0 : 1;
                bp -= 3;
                --xy;
            }
            while (xy >= 0) {
                w = (in_buf[bp] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 3] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 3] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 3] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 3] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 3] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 3] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[bp -= 3] & 0xFF) + (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                bp -= 3;
                --xy;
            }
        }
    }

    class doThFilterImpl_BUFFERFORMAT_BYTE1D_X8R8G8B8_32
    implements IdoThFilterImpl {
        doThFilterImpl_BUFFERFORMAT_BYTE1D_X8R8G8B8_32() {
        }

        public void doThFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size, int i_threshold) {
            int w;
            assert (i_output.isEqualBufferType(262146));
            int[] out_buf = (int[])i_output.getBuffer();
            byte[] in_buf = (byte[])i_input.getBuffer();
            int th = i_threshold * 3;
            int bp = (i_size.w * i_size.h - 1) * 4;
            int pix_count = i_size.h * i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int xy = pix_count - 1;
            while (xy >= pix_mod_part) {
                w = (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[xy] = w <= th ? 0 : 1;
                bp -= 4;
                --xy;
            }
            while (xy >= 0) {
                w = (in_buf[bp + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[xy] = w <= th ? 0 : 1;
                w = (in_buf[(bp -= 4) + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[(bp -= 4) + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[(bp -= 4) + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[(bp -= 4) + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[(bp -= 4) + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[(bp -= 4) + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                w = (in_buf[(bp -= 4) + 1] & 0xFF) + (in_buf[bp + 2] & 0xFF) + (in_buf[bp + 3] & 0xFF);
                out_buf[--xy] = w <= th ? 0 : 1;
                bp -= 4;
                --xy;
            }
        }
    }

    class doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32
    implements IdoThFilterImpl {
        doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32() {
        }

        public void doThFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size, int i_threshold) {
            int w;
            assert (i_output.isEqualBufferType(262146));
            int[] out_buf = (int[])i_output.getBuffer();
            int[] in_buf = (int[])i_input.getBuffer();
            int th = i_threshold * 3;
            int pix_count = i_size.h * i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int xy = pix_count - 1;
            while (xy >= pix_mod_part) {
                w = in_buf[xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                --xy;
            }
            while (xy >= 0) {
                w = in_buf[xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                w = in_buf[--xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                w = in_buf[--xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                w = in_buf[--xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                w = in_buf[--xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                w = in_buf[--xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                w = in_buf[--xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                w = in_buf[--xy];
                out_buf[xy] = (w >> 16 & 0xFF) + (w >> 8 & 0xFF) + (w & 0xFF) <= th ? 0 : 1;
                --xy;
            }
        }
    }

    class doThFilterImpl_BUFFERFORMAT_WORD1D_R5G6B5_16LE
    implements IdoThFilterImpl {
        doThFilterImpl_BUFFERFORMAT_WORD1D_R5G6B5_16LE() {
        }

        public void doThFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size, int i_threshold) {
            int w;
            assert (i_output.isEqualBufferType(262146));
            int[] out_buf = (int[])i_output.getBuffer();
            short[] in_buf = (short[])i_input.getBuffer();
            int th = i_threshold * 3;
            int pix_count = i_size.h * i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int xy = pix_count - 1;
            while (xy >= pix_mod_part) {
                w = in_buf[xy];
                out_buf[xy] = (w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3)) <= th ? 0 : 1;
                --xy;
            }
            while (xy >= 0) {
                w = in_buf[xy];
                out_buf[xy] = (w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3)) <= th ? 0 : 1;
                w = in_buf[--xy];
                w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3);
                out_buf[xy] = w <= th ? 0 : 1;
                w = in_buf[--xy];
                w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3);
                out_buf[xy] = w <= th ? 0 : 1;
                w = in_buf[--xy];
                w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3);
                out_buf[xy] = w <= th ? 0 : 1;
                w = in_buf[--xy];
                w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3);
                out_buf[xy] = w <= th ? 0 : 1;
                w = in_buf[--xy];
                w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3);
                out_buf[xy] = w <= th ? 0 : 1;
                w = in_buf[--xy];
                w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3);
                out_buf[xy] = w <= th ? 0 : 1;
                w = in_buf[--xy];
                w = ((w & 0xF800) >> 8) + ((w & 0x7E0) >> 3) + ((w & 0x1F) << 3);
                out_buf[xy] = w <= th ? 0 : 1;
                --xy;
            }
        }
    }
}

