/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import javax.media.opengl.GL;
import jp.nyatla.nyar4psg.ARToolkitThreshold4PImage;
import jp.nyatla.nyar4psg.NyARRgbRaster_PImage;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_RgbToBin;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.detector.NyARCustomSingleDetectMarker;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;

public class NyARBoard {
    public static final int CS_RIGHT = 0;
    public static final int CS_LEFT = 1;
    public final String VERSION = "NyAR4psg/0.2.2;NyARToolkit for java/2.2.0;ARToolKit/2.72.1";
    public int lostDelay = 10;
    public int lostCount = 0;
    public double cfThreshold = 0.4;
    public final double[] projection = new double[16];
    public final PVector angle = new PVector();
    public final PVector trans = new PVector();
    public double confidence = 0.0;
    public final int[][] pos2d = new int[4][2];
    public final double[] transmat = new double[16];
    public int gsThreshold = 110;
    private final NyARTransMatResult _result = new NyARTransMatResult();
    private PApplet _pa;
    private NyARCustomSingleDetectMarker _nya;
    private NyARParam _ar_param;
    private NyARRgbRaster_PImage _raster;
    private ARToolkitThreshold4PImage _filter;
    private GL _gl = null;
    private PGraphicsOpenGL _pgl = null;
    private static final double view_distance_min = 100.0;
    private static final double view_distance_max = 10000.0;

    public NyARBoard(PApplet parent, int i_width, int i_htight, String i_cparam, String i_patt, int i_patt_width, int i_projection_coord_system) {
        NyARBoard.constructor(this, parent, i_width, i_htight, i_cparam, i_patt, i_patt_width, i_projection_coord_system);
    }

    public NyARBoard(PApplet parent, int i_width, int i_htight, String i_cparam, String i_patt, int i_patt_width) {
        NyARBoard.constructor(this, parent, i_width, i_htight, i_cparam, i_patt, i_patt_width, 1);
    }

    public boolean detect(PImage i_image) {
        boolean is_marker_exist = false;
        try {
            double cf;
            this._raster.bindImage(i_image);
            this._filter.setThreshold(this.gsThreshold);
            is_marker_exist = this._nya.detectMarkerLite((INyARRgbRaster)this._raster);
            if (is_marker_exist && (cf = this._nya.getConfidence()) < this.cfThreshold) {
                is_marker_exist = false;
            }
            if (is_marker_exist) {
                NyARIntPoint[] pts = this._nya.refSquarePosition();
                int i = 0;
                while (i < 4) {
                    this.pos2d[i][0] = pts[i].x;
                    this.pos2d[i][1] = pts[i].y;
                    ++i;
                }
                this.confidence = this._nya.getConfidence();
                this.lostCount = 0;
                this._nya.getTransmationMatrix(this._result);
                this.updateTransmat(this._result);
            } else if (this.lostCount < this.lostDelay) {
                ++this.lostCount;
                is_marker_exist = true;
            } else {
                is_marker_exist = false;
            }
            this._raster.unBindImage(i_image);
            return is_marker_exist;
        }
        catch (NyARException e) {
            this._pa.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)e));
            return is_marker_exist;
        }
    }

    public void beginTransform(PGraphicsOpenGL i_pgl) {
        if (this._gl != null) {
            this._pa.die("The function beginTransform is already called.", null);
        }
        this._pgl = i_pgl;
        this.beginTransform(i_pgl.beginGL());
    }

    public void beginTransform(GL i_gl) {
        if (this._gl != null) {
            this._pa.die("The function beginTransform is already called.", null);
        }
        this._gl = i_gl;
        i_gl.glMatrixMode(5889);
        this._pa.pushMatrix();
        this._pa.resetMatrix();
        i_gl.glLoadMatrixd(this.projection, 0);
        i_gl.glMatrixMode(5888);
        this._pa.pushMatrix();
        this._pa.resetMatrix();
        i_gl.glLoadMatrixd(this.transmat, 0);
        this._pa.pushMatrix();
    }

    public void endTransform() {
        if (this._gl == null) {
            this._pa.die("The function beginTransform is never called.", null);
        }
        this._pa.popMatrix();
        this._pa.popMatrix();
        this._gl.glMatrixMode(5889);
        this._pa.popMatrix();
        this._gl.glMatrixMode(5888);
        if (this._pgl != null) {
            this._pgl.endGL();
        }
        this._gl = null;
        this._pgl = null;
    }

    private static void constructor(NyARBoard i_this, PApplet parent, int i_width, int i_htight, String i_cparam, String i_patt, int i_patt_width, int i_projection_coord_system) {
        NyARBoard.checkCoordinateSystemRange(parent, i_projection_coord_system);
        i_this._pa = parent;
        try {
            i_this._raster = new NyARRgbRaster_PImage(i_width, i_htight);
            i_this._ar_param = new NyARParam();
            i_this._ar_param.loadARParam(i_this._pa.createInput(i_cparam));
            i_this._ar_param.changeScreenSize(i_width, i_htight);
            NyARBoard.initProjection(parent, i_this._ar_param, i_this.projection, i_projection_coord_system);
            NyARCode code = new NyARCode(16, 16);
            code.loadARPatt(i_this._pa.createInput(i_patt));
            i_this._filter = new ARToolkitThreshold4PImage();
            i_this._nya = new NyARCustomSingleDetectMarker(i_this._ar_param, code, (double)i_patt_width, (INyARRasterFilter_RgbToBin)i_this._filter);
        }
        catch (NyARException e) {
            i_this._pa.die("Error while setting up NyARToolkit for java", (Exception)((Object)e));
        }
    }

    private static void initProjection(PApplet i_pa, NyARParam i_param, double[] o_projection, int i_coord_system) {
        int j;
        NyARMat trans_mat = new NyARMat(3, 4);
        NyARMat icpara_mat = new NyARMat(3, 4);
        double[][] p = new double[3][3];
        double[][] q = new double[4][4];
        NyARIntSize size = i_param.getScreenSize();
        int width = size.w;
        int height = size.h;
        i_param.getPerspectiveProjectionMatrix().decompMat(icpara_mat, trans_mat);
        double[][] icpara = icpara_mat.getArray();
        double[][] trans = trans_mat.getArray();
        int i = 0;
        while (i < 4) {
            icpara[1][i] = (double)(height - 1) * icpara[2][i] - icpara[1][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                p[i][j] = icpara[i][j] / icpara[2][2];
                ++j;
            }
            ++i;
        }
        q[0][0] = 2.0 * p[0][0] / (double)(width - 1);
        q[0][1] = 2.0 * p[0][1] / (double)(width - 1);
        q[0][2] = -(2.0 * p[0][2] / (double)(width - 1) - 1.0);
        q[0][3] = 0.0;
        q[1][0] = 0.0;
        q[1][1] = -(2.0 * p[1][1] / (double)(height - 1));
        q[1][2] = -(2.0 * p[1][2] / (double)(height - 1) - 1.0);
        q[1][3] = 0.0;
        q[2][0] = 0.0;
        q[2][1] = 0.0;
        q[2][2] = -1.02020202020202;
        q[2][3] = -202.02020202020202;
        q[3][0] = 0.0;
        q[3][1] = 0.0;
        q[3][2] = -1.0;
        q[3][3] = 0.0;
        switch (i_coord_system) {
            case 1: {
                break;
            }
            case 0: {
                q[2][2] = q[2][2] * -1.0;
                q[2][3] = q[2][3] * -1.0;
                break;
            }
            default: {
                i_pa.die("Please set NyARBoard.CS_LEFT or NyARBoard.CS_RIGHT.");
            }
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 3) {
                o_projection[i + j * 4] = q[i][0] * trans[0][j] + q[i][1] * trans[1][j] + q[i][2] * trans[2][j];
                ++j;
            }
            o_projection[i + 12] = q[i][0] * trans[0][3] + q[i][1] * trans[1][3] + q[i][2] * trans[2][3] + q[i][3];
            ++i;
        }
    }

    private void updateTransmat(NyARTransMatResult i_src) {
        this.transmat[0] = i_src.m00;
        this.transmat[4] = i_src.m01;
        this.transmat[8] = i_src.m02;
        this.transmat[12] = i_src.m03;
        this.transmat[1] = -i_src.m10;
        this.transmat[5] = -i_src.m11;
        this.transmat[9] = -i_src.m12;
        this.transmat[13] = -i_src.m13;
        this.transmat[2] = -i_src.m20;
        this.transmat[6] = -i_src.m21;
        this.transmat[10] = -i_src.m22;
        this.transmat[14] = -i_src.m23;
        this.transmat[3] = 0.0;
        this.transmat[7] = 0.0;
        this.transmat[11] = 0.0;
        this.transmat[15] = 1.0;
        this.angle.x = (float)i_src.angle.x;
        this.angle.y = (float)i_src.angle.y;
        this.angle.z = (float)i_src.angle.z;
        this.trans.x = (float)i_src.m03;
        this.trans.y = (float)i_src.m13;
        this.trans.z = (float)i_src.m23;
    }

    private static final void checkCoordinateSystemRange(PApplet i_pa, int i_cs) {
        switch (i_cs) {
            case 0: 
            case 1: {
                return;
            }
        }
        i_pa.die("Please set NyARBoard.CS_LEFT or NyARBoard.CS_RIGHT.");
    }
}

