/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARObserv2IdealMap;
import jp.nyatla.nyartoolkit.core.pca2d.INyARPca2d;
import jp.nyatla.nyartoolkit.core.pca2d.NyARPca2d_MatrixPCA_O2;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix22;

public class NyARCoord2Linear {
    private final double[] _xpos;
    private final double[] _ypos;
    private final INyARPca2d _pca;
    private final NyARDoubleMatrix22 __getSquareLine_evec = new NyARDoubleMatrix22();
    private final double[] __getSquareLine_mean = new double[2];
    private final double[] __getSquareLine_ev = new double[2];
    private final NyARObserv2IdealMap _dist_factor;

    public NyARCoord2Linear(NyARIntSize i_size, NyARCameraDistortionFactor i_distfactor_ref) {
        this._dist_factor = new NyARObserv2IdealMap(i_distfactor_ref, i_size);
        this._pca = new NyARPca2d_MatrixPCA_O2();
        this._xpos = new double[i_size.w + i_size.h];
        this._ypos = new double[i_size.w + i_size.h];
    }

    public boolean coord2Line(int i_st, int i_ed, int[] i_xcoord, int[] i_ycoord, int i_cood_num, NyARLinear o_line) throws NyARException {
        int n;
        int ed;
        int st;
        if (i_ed >= i_st) {
            double w1 = (double)(i_ed - i_st + 1) * 0.05 + 0.5;
            st = (int)((double)i_st + w1);
            ed = (int)((double)i_ed - w1);
        } else {
            double w1 = (double)(i_ed + i_cood_num - i_st + 1) % (double)i_cood_num * 0.05 + 0.5;
            st = (int)((double)i_st + w1) % i_cood_num;
            ed = (int)((double)(i_ed + i_cood_num) - w1) % i_cood_num;
        }
        if (st <= ed) {
            n = ed - st + 1;
            this._dist_factor.observ2IdealBatch(i_xcoord, i_ycoord, st, n, this._xpos, this._ypos, 0);
        } else {
            n = ed + 1 + i_cood_num - st;
            this._dist_factor.observ2IdealBatch(i_xcoord, i_ycoord, st, i_cood_num - st, this._xpos, this._ypos, 0);
            this._dist_factor.observ2IdealBatch(i_xcoord, i_ycoord, 0, ed + 1, this._xpos, this._ypos, i_cood_num - st);
        }
        if (n < 2) {
            return false;
        }
        NyARDoubleMatrix22 evec = this.__getSquareLine_evec;
        double[] mean = this.__getSquareLine_mean;
        this._pca.pca(this._xpos, this._ypos, n, evec, this.__getSquareLine_ev, mean);
        o_line.dy = evec.m01;
        o_line.dx = -evec.m00;
        o_line.c = -(o_line.dy * mean[0] + o_line.dx * mean[1]);
        return true;
    }
}

