/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#pragma once

#include "LabelOverlapChecker.h"
#include "NyARLabeling_ARToolKit.h"
#include "NyARLabelingImage.h"
#include "NyARObserv2IdealMap.h"
#include "INyARSquareDetector.h"
#include "NyARVertexCounter.h"
#include "INyARPca2d.h"
#include "SquareContourDetector.h"
#include "NyARPca2d_MatrixPCA_O2.h"
#include "ContourPickup.h"
#include "nyarcore.h"
#include <cstring>
namespace NyARToolkitCPP
{
	class NyARSquareDetector_ARToolKit : public INyARSquareDetector
	{
	private:
		int _width;
		int _height;
		NyARLabeling_ARToolKit* _labeling;
		NyARLabelingImage* _limage;

		LabelOverlapChecker<NyARLabelingLabel>* _overlap_checker;
		SquareContourDetector* _sqconvertor;
		ContourPickup* _cpickup;

		int _max_coord;
		int* _xcoord;
		int* _ycoord;
		/**
		* ői_squre_max̃}[J[oNX쐬B
		* 
		* @param i_param
		*/
	public:
		NyARSquareDetector_ARToolKit(const NyARCameraDistortionFactor& i_dist_factor_ref,const TNyARIntSize& i_size);
		virtual ~NyARSquareDetector_ARToolKit();
	private:
		void detectMarker(const NyARBinRaster& i_raster, NyARSquareStack& o_square_stack);
	};
}
